<?= $this->extend('layout/guru_layout') ?>

<?= $this->section('title') ?>
<?= $title ?>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <h2><i class="fas fa-level-up-alt"></i> <?= $title ?></h2>
    
    <?php if ($ta_aktif && $ta_tujuan): ?>
        <div class="alert alert-info">
            <p><strong>Info Proses:</strong></p>
            <ul>
                <li>Tahun Ajaran Saat Ini (TA Lama, Semester 2): <strong><?= esc($ta_aktif['nama_tahun']) ?></strong></li>
                <li>Tahun Ajaran Tujuan (TA Baru): <strong><?= esc($ta_tujuan['nama_tahun']) ?></strong></li>
                <li>
                    Proses ini dibagi menjadi 3 Tahap: 
                    <ol>
                        <li>**Naik Kelas (di Rapor):** Mengatur status kenaikan *default* (Naik/Lulus) untuk semua siswa.</li>
                        <li>**Koreksi Status:** Mengoreksi status siswa yang Tinggal Kelas.</li>
                        <li>**Pindah Kelas (di Sistem):** Memindahkan siswa secara permanen ke kelas baru di sistem untuk Tahun Ajaran tujuan.</li>
                    </ol>
                </li>
            </ul>
        </div>
    <?php else: ?>
        <div class="alert alert-danger">
            <p><strong>Peringatan!</strong> Tahun Ajaran Aktif (Lama) atau Tahun Ajaran Tujuan (Baru) belum ditemukan atau belum disetup di sistem Admin. Fitur ini tidak dapat digunakan.</p>
        </div>
    <?php endif; ?>

    <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success"><?= session()->getFlashdata('success') ?></div>
    <?php endif; ?>
    <?php if (session()->getFlashdata('error')): ?>
        <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
    <?php endif; ?>
    <?php if (session()->getFlashdata('warning')): ?>
        <div class="alert alert-warning"><?= session()->getFlashdata('warning') ?></div>
    <?php endif; ?>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Daftar Kelas Walian Anda</h6>
        </div>
        <div class="card-body">
            <?php if (empty($data_kelas)): ?>
                <p>Anda belum ditugaskan sebagai wali kelas. Fitur ini hanya dapat diakses oleh Wali Kelas.</p>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-bordered" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Kelas Asal</th>
                                <th>Status Kenaikan Rapor (Tahap 1)</th>
                                <th>Status Pindah Kelas (Tahap 2)</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($data_kelas as $kelas): ?>
                            <tr>
                                <td><?= esc($kelas['nama_kelas']) ?> (TA: <?= esc($kelas['tahun_ajaran_nama']) ?>)</td>
                                
                                <td>
                                    <?php if ($kelas['is_set_rapor']): ?>
                                        <span class="badge badge-success"><i class="fas fa-check-circle"></i> Selesai Diset</span>
                                        <small class="d-block text-muted">Status kenaikan siap dicetak di rapor.</small>
                                    <?php else: ?>
                                        <span class="badge badge-warning"><i class="fas fa-exclamation-triangle"></i> Belum Diset</span>
                                    <?php endif; ?>
                                </td>
                                
                                <td>
                                    <?php if ($kelas['is_processed']): ?>
                                        <span class="badge badge-success"><i class="fas fa-check-double"></i> Pindah Kelas Selesai</span>
                                        <small class="d-block text-muted">Siswa sudah berada di kelas baru (TA Tujuan).</small>
                                    <?php elseif ($kelas['is_set_rapor']): ?>
                                        <span class="badge badge-info"><i class="fas fa-clock"></i> Menunggu Pindah Sistem</span>
                                    <?php else: ?>
                                        <span class="badge badge-secondary">Menunggu Tahap 1</span>
                                    <?php endif; ?>
                                </td>
                                
                                <td>
                                    <?php if (!$kelas['is_set_rapor']): ?>
                                        <form action="<?= base_url('guru/siswa/setKenaikanRapor') ?>" method="post" style="display: inline;" onsubmit="return confirm('Yakin ingin mengatur status kenaikan rapor DEFAULT (Naik/Lulus) untuk kelas <?= esc($kelas['nama_kelas']) ?>?');">
                                            <?= csrf_field() ?>
                                            <input type="hidden" name="kelas_id" value="<?= esc($kelas['id_kelas']) ?>">
                                            <input type="hidden" name="tahun_ajaran_id" value="<?= esc($kelas['tahun_ajaran_id']) ?>">
                                            <button type="submit" class="btn btn-sm btn-primary">
                                                <i class="fas fa-file-export"></i> Naik Kelas
                                            </button>
                                        </form>
                                    <?php else: ?>
                                        <?php if (!$kelas['is_processed']): ?>
                                            <a href="<?= base_url('guru/siswa/koreksiKenaikanKelas/' . $kelas['id_kelas'] . '/' . $kelas['tahun_ajaran_id']) ?>" class="btn btn-danger btn-sm">
                                                <i class="fa fa-edit"></i> Koreksi Status
                                            </a>
                                        <?php endif; ?>
                                        
                                        <form id="formPindahKelas_<?= esc($kelas['id_kelas']) ?>" action="<?= base_url('guru/siswa/prosesPindahKelas') ?>" method="post" style="display: inline;">
										<?= csrf_field() ?>
										
										<input type="hidden" name="kelas_lama_id" value="<?= esc($kelas['id_kelas']) ?>">             <input type="hidden" name="ta_id_lama" value="<?= esc($kelas['tahun_ajaran_id']) ?>">          <input type="hidden" name="ta_id_baru" value="<?= esc($ta_tujuan ? $ta_tujuan['id'] : '') ?>"> <?php 
											$canProceed = $kelas['is_set_rapor'] && !$kelas['is_processed'];
											$disabled = $canProceed ? '' : 'disabled';
										?>

										<button type="button" 
												class="btn btn-sm btn-success" 
												<?= $disabled ?>
												onclick="confirmPindahKelas(<?= esc($kelas['id_kelas']) ?>, '<?= esc($kelas['nama_kelas']) ?>')">
											<i class="fas fa-arrow-circle-up"></i> Update Kelas
										</button>
									</form>
                                    <?php endif; ?>

                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
    function confirmPindahKelas(kelasId, namaKelas) {
        // Konfirmasi yang diminta user
        const konfirmasi = "APAKAH ANDA YAKIN? Tindakan ini akan memindahkan SEMUA siswa di kelas " + namaKelas + " ke kelas baru/Lulus di sistem, berdasarkan status yang sudah diatur/dikoreksi.\n\nPASTIKAN ANDA SUDAH MELAKUKAN KOREKSI STATUS JIKA ADA SISWA YANG TINGGAL KELAS! Proses ini tidak dapat dibatalkan!";

        if (confirm(konfirmasi)) {
            // Jika user klik OK, submit form
            document.getElementById('formPindahKelas_' + kelasId).submit();
        }
    }
</script>
<?= $this->endSection() ?>