<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\EkstrakurikulerMasterModel;
use App\Models\UserModel;

class Ekstrakurikuler extends BaseController
{
    protected $ekstrakurikulerMasterModel;
    protected $userModel;

    public function __construct()
    {
        $this->ekstrakurikulerMasterModel = new EkstrakurikulerMasterModel();
        $this->userModel = new UserModel();
    }
    
    // Metode untuk menampilkan daftar ekstrakurikuler
    public function index()
    {
        // Ambil semua data ekstrakurikuler
        $ekskul = $this->ekstrakurikulerMasterModel->findAll();

        // Cari nama guru untuk setiap ekskul
        foreach ($ekskul as &$e) {
            if ($e['penanggung_jawab_id']) {
                $guru = $this->userModel->find($e['penanggung_jawab_id']);
                $e['penanggung_jawab_nama'] = $guru['nama'];
            } else {
                $e['penanggung_jawab_nama'] = '-';
            }
        }
        
        $data = [
            'title' => 'Daftar Ekstrakurikuler',
            'ekskul_list' => $ekskul,
        ];

        return view('admin/ekstrakurikuler/index', $data);
    }
    
    // Metode untuk menampilkan form tambah ekstrakurikuler
    public function create()
    {
        // Mengambil data guru untuk dropdown penanggung jawab
        $gurus = $this->userModel->where('role', 'guru')->findAll();
        
        $data = [
            'title' => 'Tambah Ekstrakurikuler Baru',
            'gurus' => $gurus,
            'validation' => \Config\Services::validation(),
        ];
        
        return view('admin/ekstrakurikuler/create', $data);
    }
    
    // Metode untuk menyimpan data ekstrakurikuler baru
    public function save()
    {
        // Validasi
        $rules = [
            'nama_ekskul' => 'required|is_unique[ekstrakurikuler_master.nama_ekskul]',
            'penanggung_jawab_id' => 'permit_empty|integer',
        ];
        
        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }
        
        $data = [
            'nama_ekskul' => $this->request->getPost('nama_ekskul'),
            // Jika penanggung jawab kosong, simpan sebagai NULL
            'penanggung_jawab_id' => $this->request->getPost('penanggung_jawab_id') ?: null,
        ];
        
        $this->ekstrakurikulerMasterModel->save($data);
        
        session()->setFlashdata('success', 'Ekstrakurikuler berhasil ditambahkan.');
        
        return redirect()->to(base_url('admin/ekstrakurikuler'));
    }

    // Metode untuk menampilkan form edit ekstrakurikuler
    public function edit($id = null)
    {
        if ($id === null) {
            return redirect()->to(base_url('admin/ekstrakurikuler'));
        }

        $ekskul = $this->ekstrakurikulerMasterModel->find($id);

        if (!$ekskul) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        }

        // Mengambil data guru untuk dropdown penanggung jawab
        $gurus = $this->userModel->where('role', 'guru')->findAll();
        
        $data = [
            'title' => 'Edit Ekstrakurikuler',
            'ekskul' => $ekskul,
            'gurus' => $gurus,
            'validation' => \Config\Services::validation(),
        ];

        return view('admin/ekstrakurikuler/edit', $data);
    }

    // Metode untuk memperbarui data ekstrakurikuler
    public function update($id)
    {
        $ekskulLama = $this->ekstrakurikulerMasterModel->find($id);
        $nama_ekskul_rules = 'required';
        if ($ekskulLama['nama_ekskul'] != $this->request->getPost('nama_ekskul')) {
            $nama_ekskul_rules .= '|is_unique[ekstrakurikuler_master.nama_ekskul]';
        }

        if (!$this->validate([
            'nama_ekskul' => [
                'rules' => $nama_ekskul_rules,
                'errors' => [
                    'required' => 'Nama ekstrakurikuler harus diisi.',
                    'is_unique' => 'Nama ekstrakurikuler sudah ada.',
                ]
            ],
            'penanggung_jawab_id' => [
                'rules' => 'permit_empty|integer',
            ]
        ])) {
            return redirect()->back()->withInput();
        }

        $data = [
            'nama_ekskul' => $this->request->getPost('nama_ekskul'),
            'penanggung_jawab_id' => $this->request->getPost('penanggung_jawab_id') ?: null,
        ];

        $this->ekstrakurikulerMasterModel->update($id, $data);

        session()->setFlashdata('success', 'Ekstrakurikuler berhasil diperbarui.');
        return redirect()->to(base_url('admin/ekstrakurikuler'));
    }
    
    public function delete($id)
    {
        $this->ekstrakurikulerMasterModel->delete($id);
        session()->setFlashdata('success', 'Ekstrakurikuler berhasil dihapus.');
        return redirect()->to(base_url('admin/ekstrakurikuler'));
    }
}
