<?php namespace App\Controllers\Guru;

use App\Controllers\BaseController;
use App\Models\SiswaModel;
use App\Models\NilaiAkhirMapelModel;
use App\Models\EkskulSiswaModel;
use App\Models\KehadiranModel;
use App\Models\CatatanWaliKelasModel;
use App\Models\TahunAjaranModel;
use App\Models\KelasModel;
use App\Models\UserModel;
use App\Models\SekolahModel;
use App\Models\MataPelajaranModel;
use App\Models\EkstrakurikulerMasterModel;

use Dompdf\Dompdf;

class Rapor extends BaseController
{
    protected $siswaModel;
    protected $nilaiMapelModel;
    protected $ekskulSiswaModel;
    protected $kehadiranModel;
    protected $catatanWaliKelasModel;
    protected $tahunAjaranModel;
    protected $kelasModel;
    protected $userModel;
    protected $sekolahModel;
    protected $mataPelajaranModel;
    protected $ekstrakurikulerMasterModel;

    public function __construct()
    {
        $this->siswaModel = new SiswaModel();
        $this->nilaiMapelModel = new NilaiAkhirMapelModel();
        $this->ekskulSiswaModel = new EkskulSiswaModel();
        $this->kehadiranModel = new KehadiranModel();
        $this->catatanWaliKelasModel = new CatatanWaliKelasModel();
        $this->tahunAjaranModel = new TahunAjaranModel();
        $this->kelasModel = new KelasModel();
        $this->userModel = new UserModel();
        $this->sekolahModel = new SekolahModel();
        $this->mataPelajaranModel = new MataPelajaranModel();
        $this->ekstrakurikulerMasterModel = new EkstrakurikulerMasterModel();
    }
    
    public function index()
    {
        $guruId = session()->get('user_id');
        $waliKelasData = $this->kelasModel->where('guru_kelas_id', $guruId)->first();

        if (empty($waliKelasData)) {
            session()->setFlashdata('error', 'Anda tidak ditugaskan sebagai wali kelas. Fitur ini hanya untuk wali kelas.');
            return redirect()->to(base_url('guru/dashboard'));
        }

        $siswa = $this->siswaModel->where('kelas_id', $waliKelasData['id_kelas'])->findAll();
        
        $data = [
            'tahun_ajaran' => $this->tahunAjaranModel->findAll(),
            'siswa' => $siswa,
        ];
        
        return view('guru/rapor/index_rapor', $data);
    }

    private function _getFase($kelas_id)
    {
        $kelas = $this->kelasModel->find($kelas_id);
        if (!$kelas) return null;

        $kelas_number = filter_var($kelas['nama_kelas'], FILTER_SANITIZE_NUMBER_INT);
        if ($kelas_number == 1 || $kelas_number == 2) {
            return 'A';
        } elseif ($kelas_number == 3 || $kelas_number == 4) {
            return 'B';
        } elseif ($kelas_number == 5 || $kelas_number == 6) {
            return 'C';
        }
        return null;
    }
    
    private function _getRaporData($siswaId, $tahunAjaranId, $semester)
    {
        $siswa = $this->siswaModel->find($siswaId);
        if (!$siswa) return null;

        $kelas = $this->kelasModel->find($siswa['kelas_id']);
        $tahunAjaran = $this->tahunAjaranModel->find($tahunAjaranId);

        $waliKelas = $this->userModel->find($kelas['guru_kelas_id'] ?? null);
        $sekolah = $this->sekolahModel->first();
        $kepalaSekolah = $this->userModel->find($sekolah['kepala_sekolah_id'] ?? null);

        // Baris ini sudah diperbaiki, menggunakan 'mata_pelajaran.id'
        $nilaiMapel = $this->nilaiMapelModel
            ->select('nilai_akhir_mapel.*, mata_pelajaran.nama_mapel')
            ->join('mata_pelajaran', 'mata_pelajaran.id = nilai_akhir_mapel.mapel_id')
            ->where('nilai_akhir_mapel.siswa_id', $siswaId)
            ->where('nilai_akhir_mapel.tahun_ajaran_id', $tahunAjaranId)
            ->where('nilai_akhir_mapel.semester', $semester)
			->orderBy('nilai_akhir_mapel.mapel_id', 'ASC')
            ->findAll();
        
        // Join ini sudah benar, 'ekstrakurikuler_master' menggunakan 'id'
        $ekstrakurikuler = $this->ekskulSiswaModel
            ->select('ekskul_siswa.*, ekstrakurikuler_master.nama_ekskul')
            ->join('ekstrakurikuler_master', 'ekstrakurikuler_master.id = ekskul_siswa.ekskul_id')
            ->where('ekskul_siswa.siswa_id', $siswaId)
            ->where('ekskul_siswa.tahun_ajaran_id', $tahunAjaranId)
            ->where('ekskul_siswa.semester', $semester)
            ->findAll();

        $kehadiran = $this->kehadiranModel
            ->where('siswa_id', $siswaId)
            ->where('tahun_ajaran_id', $tahunAjaranId)
            ->where('semester', $semester)
            ->first();

        $catatan = $this->catatanWaliKelasModel
            ->where('siswa_id', $siswaId)
            ->where('tahun_ajaran_id', $tahunAjaranId)
            ->where('semester', $semester)
            ->first();
        
        $fase = $this->_getFase($kelas['id_kelas']);

        return [
            'siswa' => $siswa,
            'kelas' => $kelas,
            'tahunAjaran' => $tahunAjaran,
            'nilaiMapel' => $nilaiMapel,
            'ekstrakurikuler' => $ekstrakurikuler,
            'kehadiran' => $kehadiran,
            'catatan' => $catatan,
            'waliKelas' => $waliKelas,
            'kepalaSekolah' => $kepalaSekolah,
            'sekolah' => $sekolah,
            'fase' => $fase,
        ];
    }
    
    public function pratinjauRapor()
    {
        $siswaId = $this->request->getPost('siswa_id');
        $tahunAjaranId = $this->request->getPost('tahun_ajaran_id');
        $semester = $this->request->getPost('semester');
        
        if (!$siswaId || !$tahunAjaranId || !$semester) {
            return "Data tidak lengkap.";
        }
        
        $data = $this->_getRaporData($siswaId, $tahunAjaranId, $semester);
        
        if (!$data) {
            return "Data siswa tidak ditemukan.";
        }
        
        return view('guru/rapor/rapor_view', $data);
    }
    
    public function cetakRapor()
    {
        $siswaId = $this->request->getPost('siswa_id');
        $tahunAjaranId = $this->request->getPost('tahun_ajaran_id');
        $semester = $this->request->getPost('semester');
        
        if (!$siswaId || !$tahunAjaranId || !$semester) {
            return "Data tidak lengkap.";
        }
        
        $data = $this->_getRaporData($siswaId, $tahunAjaranId, $semester);
    
        if (!$data) {
            return "Data siswa tidak ditemukan.";
        }
    
        $html = view('guru/rapor/rapor_view', $data);
        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->render();
    
        // Tambahkan header ini sebelum streaming untuk memberitahu browser bahwa ini adalah PDF
        $filename = 'Rapor_' . str_replace(' ', '_', $data['siswa']['nama_lengkap']) . '_' . $data['tahunAjaran']['nama_tahun'] . '.pdf';
        
        // Memberikan instruksi ke browser untuk menganggap ini sebagai PDF
        $this->response->setHeader('Content-Type', 'application/pdf');
        $this->response->setHeader('Content-Disposition', 'inline; filename="' . $filename . '"');
        
        // Mengeluarkan output PDF ke browser
        $dompdf->stream($filename, ['Attachment' => false]);
    }
    
    public function cetakLeger()
    {
        // Cek apakah user adalah wali kelas
        $guruId = session()->get('user_id');
        $waliKelasData = $this->kelasModel->where('guru_kelas_id', $guruId)->first();

        if (empty($waliKelasData)) {
            return "Anda tidak ditugaskan sebagai wali kelas. Fitur ini hanya untuk wali kelas.";
        }

        $tahunAjaranId = $this->request->getPost('tahun_ajaran_id');
        $semester = $this->request->getPost('semester');

        if (!$tahunAjaranId || !$semester) {
            return "Tahun Ajaran atau Semester tidak lengkap.";
        }

        $siswaList = $this->siswaModel->where('kelas_id', $waliKelasData['id_kelas'])->findAll();
        $dataLeger = [];
        $allRerata = [];

        foreach ($siswaList as $siswa) {
            $nilaiMapel = $this->nilaiMapelModel
                ->where('siswa_id', $siswa['id'])
                ->where('tahun_ajaran_id', $tahunAjaranId)
                ->where('semester', $semester)
                ->findAll();

            $totalNilai = 0;
            $jumlahMapel = count($nilaiMapel);
            $nilaiSiswa = [];
            
            foreach ($nilaiMapel as $nilai) {
                $totalNilai += $nilai['nilai_akhir'];
                $nilaiSiswa[$nilai['mapel_id']] = $nilai['nilai_akhir'];
            }

            $rerata = ($jumlahMapel > 0) ? round($totalNilai / $jumlahMapel, 2) : 0;
            $allRerata[] = ['siswa_id' => $siswa['id'], 'rerata' => $rerata];

            $dataLeger[] = [
                'siswa' => $siswa,
                'nilai_mapel' => $nilaiSiswa,
                'total_nilai' => $totalNilai,
                'rerata' => $rerata,
                'peringkat' => 0, // Akan dihitung setelah semua data terkumpul
            ];
        }
        
        // Hitung peringkat
        usort($allRerata, function($a, $b) {
            return $b['rerata'] <=> $a['rerata'];
        });
        
        $rankingMap = [];
        $rank = 1;
        $prevRerata = null;
        $tieCount = 0;
        foreach ($allRerata as $key => $item) {
            if ($prevRerata !== null && $item['rerata'] < $prevRerata) {
                $rank += $tieCount;
                $tieCount = 1;
            } else {
                $tieCount++;
            }
            $rankingMap[$item['siswa_id']] = $rank;
            $prevRerata = $item['rerata'];
        }

        // Terapkan peringkat ke data leger
        foreach ($dataLeger as &$siswaData) {
            $siswaData['peringkat'] = $rankingMap[$siswaData['siswa']['id']];
        }

        $mapelList = $this->mataPelajaranModel->findAll();
        $tahunAjaran = $this->tahunAjaranModel->find($tahunAjaranId);
        $kelas = $this->kelasModel->find($waliKelasData['id_kelas']);
        $waliKelas = $this->userModel->find($waliKelasData['guru_kelas_id']);

        $data = [
            'dataLeger' => $dataLeger,
            'mapelList' => $mapelList,
            'tahunAjaran' => $tahunAjaran,
            'kelas' => $kelas,
            'waliKelas' => $waliKelas,
        ];

        $html = view('guru/rapor/leger_view', $data);
        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'landscape');
        $dompdf->render();

        $filename = 'Leger_Kelas_' . str_replace(' ', '_', $kelas['nama_kelas']) . '_' . $tahunAjaran['nama_tahun'] . '.pdf';
        
        $this->response->setHeader('Content-Type', 'application/pdf');
        $this->response->setHeader('Content-Disposition', 'inline; filename="' . $filename . '"');
        
        $dompdf->stream($filename, ['Attachment' => false]);
    }
    
    public function cetakPengambilanRapor()
    {
        $guruId = session()->get('user_id');
        $waliKelasData = $this->kelasModel->where('guru_kelas_id', $guruId)->first();

        if (empty($waliKelasData)) {
            return "Anda tidak ditugaskan sebagai wali kelas. Fitur ini hanya untuk wali kelas.";
        }

        $tahunAjaranId = $this->request->getPost('tahun_ajaran_id');
        $semester = $this->request->getPost('semester');

        $siswaList = $this->siswaModel
            ->where('kelas_id', $waliKelasData['id_kelas'])
            ->orderBy('nama_lengkap', 'ASC')
            ->findAll();
        
        $waliKelas = $this->userModel->find($waliKelasData['guru_kelas_id']);
        $kelas = $this->kelasModel->find($waliKelasData['id_kelas']);
        $sekolah = $this->sekolahModel->first();
        $tahunAjaran = $this->tahunAjaranModel->find($tahunAjaranId);

        $data = [
            'siswaList' => $siswaList,
            'waliKelas' => $waliKelas,
            'kelas' => $kelas,
            'sekolah' => $sekolah,
            'tahunAjaran' => $tahunAjaran,
        ];

        $html = view('guru/rapor/pengambilan_rapor_view', $data);
        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->render();

        $filename = 'Pengambilan_Rapor_Kelas_' . str_replace(' ', '_', $kelas['nama_kelas']) . '_' . $tahunAjaran['nama_tahun'] . '.pdf';
        
        $this->response->setHeader('Content-Type', 'application/pdf');
        $this->response->setHeader('Content-Disposition', 'inline; filename="' . $filename . '"');
        
        $dompdf->stream($filename, ['Attachment' => false]);
    }
    
}