<?php

namespace App\Models;

use CodeIgniter\Model;

class KelasModel extends Model
{
    protected $table            = 'kelas';
    protected $primaryKey       = 'id_kelas';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['nama_kelas', 'guru_kelas_id', 'tahun_ajaran_id'];

    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules = [
        'nama_kelas'      => 'required|min_length[1]|is_unique[kelas.nama_kelas,id,{id}]', // Perlu validasi gabungan dengan tahun_ajaran_id di controller
        'guru_kelas_id'   => 'permit_empty|is_natural_no_zero',
        'tahun_ajaran_id' => 'required|is_natural_no_zero',
    ];
    protected $validationMessages = [];
    protected $skipValidation = false;
	
	public function getWaliKelasWithGuruInfo(int $kelas_id)
    {
        // Lakukan join antara tabel 'kelas' dan 'users' berdasarkan 'guru_kelas_id'
        return $this->select('kelas.*, users.nama, users.nip')
                    ->join('users', 'users.id = kelas.guru_kelas_id', 'left')
                    ->where('kelas.id_kelas', $kelas_id)
                    ->first();
    }
}