<?php

namespace App\Models;

use CodeIgniter\Model;

class PenilaianP5Model extends Model
{
    protected $table            = 'penilaian_p5';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['siswa_id', 'proyek_p5_id', 'dimensi_profil', 'sub_elemen_profil', 'deskripsi_pencapaian', 'semester', 'tahun_ajaran_id'];

    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules = [
        'siswa_id'            => 'required|is_natural_no_zero',
        'proyek_p5_id'        => 'required|is_natural_no_zero',
        'dimensi_profil'      => 'required|min_length[3]',
        'deskripsi_pencapaian' => 'required|min_length[10]',
        'semester'            => 'required|in_list[1,2]',
        'tahun_ajaran_id'     => 'required|is_natural_no_zero',
    ];
    protected $validationMessages = [];
    protected $skipValidation = false;
}