<?= $this->extend('layout/admin_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <form action="<?= base_url('admin/ekstrakurikuler/save'); ?>" method="post">
                    <?= csrf_field(); ?>
                    <div class="form-group">
                        <label for="nama_ekskul">Nama Ekstrakurikuler</label>
                        <input type="text" class="form-control" id="nama_ekskul" name="nama_ekskul" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="penanggung_jawab_id">Penanggung Jawab</label>
                        <select class="form-control" id="penanggung_jawab_id" name="penanggung_jawab_id">
                            <option value="">(Wali Kelas)</option>
                            <?php foreach($gurus as $guru): ?>
                                <option value="<?= $guru['id'] ?>"><?= $guru['nama'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                    <a href="<?= base_url('admin/ekstrakurikuler'); ?>" class="btn btn-secondary">Batal</a>
                </form>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>