<?php

namespace App\Controllers\Guru;

use App\Controllers\BaseController;
use App\Models\KelasModel;
use App\Models\SiswaModel;
use App\Models\SekolahModel;
use App\Models\TahunAjaranModel;
use App\Models\PetunjukRaporModel;
use App\Models\UserModel; 

use Dompdf\Dompdf;

class RaporCover extends BaseController
{
    protected $kelasModel;
    protected $siswaModel;
    protected $sekolahModel;
    protected $tahunAjaranModel;
    protected $petunjukRaporModel;
    protected $UserModel;

    public function __construct()
    {
        $this->kelasModel = new KelasModel();
        $this->siswaModel = new SiswaModel();
        $this->sekolahModel = new SekolahModel();
        $this->tahunAjaranModel = new TahunAjaranModel();
        $this->petunjukRaporModel = new PetunjukRaporModel();
        $this->UserModel = new UserModel();
    }

    public function index()
    {
        $guru_id = session()->get('user_id');
        $wali_kelas_data = $this->kelasModel->where('guru_kelas_id', $guru_id)->first();

        if (empty($wali_kelas_data)) {
            session()->setFlashdata('error', 'Anda tidak ditugaskan sebagai wali kelas. Fitur ini hanya untuk wali kelas.');
            return redirect()->to(base_url('guru/dashboard'));
        }

        $selected_kelas_id = $wali_kelas_data['id_kelas'];
        $selected_tahun_ajaran_id = $this->request->getPost('tahun_ajaran_id') ?? old('tahun_ajaran_id') ?? '';
        $selected_siswa_id = $this->request->getPost('siswa_id') ?? old('siswa_id') ?? '';

        $siswa_list = $this->siswaModel->where('kelas_id', $selected_kelas_id)->findAll();
        $sekolah_data = $this->sekolahModel->first();
        $petunjuk_rapor = null;
        $selected_siswa = null;
        $tahun_ajaran_data = null;
        
        $kepala_sekolah_data = null;
        if (!empty($sekolah_data['kepala_sekolah_id'])) {
            $kepala_sekolah_data = $this->UserModel->find($sekolah_data['kepala_sekolah_id']);
        }

        if (!empty($selected_tahun_ajaran_id)) {
            $petunjuk_rapor = $this->petunjukRaporModel->where([
                'kelas_id' => $selected_kelas_id,
                'tahun_ajaran_id' => $selected_tahun_ajaran_id,
            ])->first();
            $tahun_ajaran_data = $this->tahunAjaranModel->find($selected_tahun_ajaran_id);
        }
        
        if (!empty($selected_siswa_id)) {
             $selected_siswa = $this->siswaModel->find($selected_siswa_id);
        }

        $data = [
            'title' => 'Cetak Cover Rapor',
            'kelas' => $wali_kelas_data,
            'tahun_ajaran' => $this->tahunAjaranModel->findAll(),
            'siswa_list' => $siswa_list,
            'sekolah' => $sekolah_data,
            'kepala_sekolah' => $kepala_sekolah_data,
            'petunjuk_rapor' => $petunjuk_rapor,
            'selected_tahun_ajaran_id' => $selected_tahun_ajaran_id,
            'selected_siswa_id' => $selected_siswa_id,
            'selected_siswa' => $selected_siswa,
            'tahun_ajaran_data' => $tahun_ajaran_data,
        ];

        return view('guru/rapor_cover/index', $data);
    }
    
    // ... Metode save() dan generate_pdf() yang sudah ada
    // Hanya perlu dipastikan bahwa generate_pdf() menggunakan getWaliKelasWithGuruInfo
    
    public function save()
    {
        $guru_id = session()->get('user_id');
        $wali_kelas_data = $this->kelasModel->where('guru_kelas_id', $guru_id)->first();
        if (empty($wali_kelas_data)) {
            session()->setFlashdata('error', 'Anda tidak ditugaskan sebagai wali kelas.');
            return redirect()->to(base_url('guru/rapor_cover'));
        }

        $kelas_id = $wali_kelas_data['id_kelas'];
        $tahun_ajaran_id = $this->request->getPost('tahun_ajaran_id');
        $petunjuk_pengisian = $this->request->getPost('petunjuk_pengisian');
        
        if (empty($tahun_ajaran_id)) {
            session()->setFlashdata('error', 'Tahun ajaran tidak boleh kosong.');
            return redirect()->to(base_url('guru/rapor_cover'));
        }

        $data_to_save = [
            'kelas_id' => $kelas_id,
            'tahun_ajaran_id' => $tahun_ajaran_id,
            'petunjuk_pengisian' => $petunjuk_pengisian,
        ];
        
        $existing_record = $this->petunjukRaporModel->where([
            'kelas_id' => $kelas_id,
            'tahun_ajaran_id' => $tahun_ajaran_id,
        ])->first();

        if ($existing_record) {
            $this->petunjukRaporModel->update($existing_record['id'], $data_to_save);
        } else {
            $this->petunjukRaporModel->insert($data_to_save);
        }

        session()->setFlashdata('success', 'Petunjuk pengisian rapor berhasil disimpan.');
        return redirect()->to(base_url('guru/rapor_cover'));
    }

	public function preview($siswa_id, $tahun_ajaran_id)
	{
    // Cek kelengkapan data
    if (empty($siswa_id) || empty($tahun_ajaran_id)) {
        return 'Data Siswa atau Tahun Ajaran tidak lengkap.';
    }

    $guru_id = session()->get('user_id');
    $wali_kelas_data = $this->kelasModel->where('guru_kelas_id', $guru_id)->first();
    
    // Pastikan user adalah wali kelas
    if (empty($wali_kelas_data)) {
         return 'Akses ditolak.';
    }

    $selected_kelas_id = $wali_kelas_data['id_kelas'];
    $siswa_data = $this->siswaModel->find($siswa_id);
    
    // Validasi siswa
    if (empty($siswa_data) || $siswa_data['kelas_id'] != $selected_kelas_id) {
        return 'Data siswa tidak ditemukan atau tidak berada di kelas Anda.';
    }
    
    // Ambil data yang dibutuhkan, sama seperti di generate_pdf()
    $petunjuk_rapor = $this->petunjukRaporModel->where([
        'kelas_id' => $selected_kelas_id,
        'tahun_ajaran_id' => $tahun_ajaran_id,
    ])->first();

    $sekolah_data = $this->sekolahModel->first();
    $tahun_ajaran_data = $this->tahunAjaranModel->find($tahun_ajaran_id);
    $wali_kelas_guru = $this->kelasModel->getWaliKelasWithGuruInfo($selected_kelas_id);
    
    $kepala_sekolah_data = null;
    if (!empty($sekolah_data['kepala_sekolah_id'])) {
        $kepala_sekolah_data = $this->UserModel->find($sekolah_data['kepala_sekolah_id']);
    }
    
    $logo_base64 = null;
    $logo_path = FCPATH . 'assets/img/logo_sekolah.png';
    if (file_exists($logo_path)) {
        $type = pathinfo($logo_path, PATHINFO_EXTENSION);
        $data_image = file_get_contents($logo_path);
        $logo_base64 = 'data:image/' . $type . ';base64,' . base64_encode($data_image);
    }
    
    $css_path = FCPATH . 'assets/css/rapor_cover.css';
    $style_css = file_get_contents($css_path);

    $data = [
        'siswa' => $siswa_data,
        'sekolah' => $sekolah_data,
        'petunjuk_rapor' => $petunjuk_rapor,
        'logo_base64' => $logo_base64,
        'style_css' => $style_css,
        'tahun_ajaran_data' => $tahun_ajaran_data,
        'wali_kelas_guru' => $wali_kelas_guru,
        'kepala_sekolah' => $kepala_sekolah_data,
		'is_preview' => true,
    ];

    // PERUBAHAN KRITIS:
    // Hanya me-return view HTML tanpa Dompdf, sehingga bisa dimuat di iframe.
    return view('guru/rapor_cover/rapor_cover_pdf', $data);
	}
   
	public function generate_pdf()
    {
        $siswa_id = $this->request->getPost('siswa_id');
        $tahun_ajaran_id = $this->request->getPost('tahun_ajaran_id');
        
        if (empty($siswa_id) || empty($tahun_ajaran_id)) {
            return 'Data tidak lengkap.';
        }

        $guru_id = session()->get('user_id');
        $wali_kelas_data = $this->kelasModel->where('guru_kelas_id', $guru_id)->first();
        $selected_kelas_id = $wali_kelas_data['id_kelas'];
        
        $siswa_data = $this->siswaModel->find($siswa_id);
        
        if (empty($siswa_data) || $siswa_data['kelas_id'] != $selected_kelas_id) {
            return 'Data siswa tidak ditemukan atau tidak berada di kelas Anda.';
        }
        
        $petunjuk_rapor = $this->petunjukRaporModel->where([
            'kelas_id' => $selected_kelas_id,
            'tahun_ajaran_id' => $tahun_ajaran_id,
        ])->first();

        $sekolah_data = $this->sekolahModel->first();
        $tahun_ajaran_data = $this->tahunAjaranModel->find($tahun_ajaran_id);
        $wali_kelas_guru = $this->kelasModel->getWaliKelasWithGuruInfo($selected_kelas_id);
        
        $kepala_sekolah_data = null;
        if (!empty($sekolah_data['kepala_sekolah_id'])) {
            $kepala_sekolah_data = $this->UserModel->find($sekolah_data['kepala_sekolah_id']);
        }
        
        $logo_base64 = null;
        $logo_path = FCPATH . 'assets/img/logo_sekolah.png';
        if (file_exists($logo_path)) {
            $type = pathinfo($logo_path, PATHINFO_EXTENSION);
            $data_image = file_get_contents($logo_path);
            $logo_base64 = 'data:image/' . $type . ';base64,' . base64_encode($data_image);
        }
        
        $css_path = FCPATH . 'assets/css/rapor_cover.css';
        $style_css = file_get_contents($css_path);

        $data = [
            'siswa' => $siswa_data,
            'sekolah' => $sekolah_data,
            'petunjuk_rapor' => $petunjuk_rapor,
            'logo_base64' => $logo_base64,
            'style_css' => $style_css,
            'tahun_ajaran_data' => $tahun_ajaran_data,
            'wali_kelas_guru' => $wali_kelas_guru,
            'kepala_sekolah' => $kepala_sekolah_data,
			'is_preview' => false,
        ];

        $html = view('guru/rapor_cover/rapor_cover_pdf', $data);

        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->render();

        $file_name = 'Cover Rapor ' . $siswa_data['nama_lengkap'] . '.pdf';
        
        $dompdf->stream($file_name);
    }
}
