<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('title') ?><?= $title ?><?= $this->endSection() ?>

<?= $this->section('content') ?>
<h1><?= esc($title) ?></h1>
<?php if (session()->getFlashdata('warning')) : ?>
    <div class="alert alert-warning">
        <?= session()->getFlashdata('warning') ?>
        <?php if (session()->getFlashdata('import_errors')) : ?>
            <p><strong>Detail Error:</strong></p>
            <ul>
                <?php foreach (session()->getFlashdata('import_errors') as $error) : ?>
                    <li><?= esc($error) ?></li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
    </div>
<?php endif; ?>
<p>Unggah file Excel (.xls, .xlsx) atau CSV (.csv) untuk mengimport data siswa.</p>

<div class="alert alert-info">
    <strong>Petunjuk:</strong>
    <p>Pastikan file Anda memiliki kolom-kolom berikut dalam urutan yang tepat (atau sesuaikan mapping di controller):</p>
    <p>NISN | NIS | Pendidikan Sebelumnya | Nama Lengkap | Nama Panggilan | Jenis Kelamin | Agama | ID Kelas | Tempat Lahir | Tanggal Lahir (YYYY-MM-DD) | Alamat | Kelurahan/Desa | Kapanewon | Kabupaten/Kota | Provinsi | Nama Ayah | Pekerjaan Ayah | Nama Ibu | Pekerjaan Ibu | Nama Wali | Pekerjaan Wali | Alamat Wali</p>
    <p>Untuk kolom "ID Kelas", isikan ID numerik dari tabel kelas Anda (misal: 1, 2, 3), bukan nama kelas.</p>
    <p>Ukuran file maksimal 2MB.</p>
</div>

<?php if (session()->getFlashdata('success')) : ?>
    <div class="alert alert-success">
        <?= session()->getFlashdata('success') ?>
    </div>
<?php endif; ?>
<?php if (session()->getFlashdata('warning')) : ?>
    <div class="alert alert-warning">
        <?= session()->getFlashdata('warning') ?>
        <?php if (session()->getFlashdata('import_errors')) : ?>
            <p><strong>Detail Error:</strong></p>
            <ul>
                <?php foreach (session()->getFlashdata('import_errors') as $error) : ?>
                    <li><?= esc($error) ?></li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
    </div>
<?php endif; ?>
<?php if (session()->getFlashdata('error')) : ?>
    <div class="alert alert-danger">
        <?= session()->getFlashdata('error') ?>
    </div>
<?php endif; ?>

<form action="<?= base_url('admin/siswa/import/upload') ?>" method="post" enctype="multipart/form-data">
    <?= csrf_field() ?>

    <label for="file_excel">Pilih File Excel/CSV:</label>
    <input type="file" id="file_excel" name="file_excel"
           class="<?= ($validation->hasError('file_excel')) ? 'is-invalid' : ''; ?>" required>
    <?php if ($validation->hasError('file_excel')): ?>
        <p class="text-danger"><?= $validation->getError('file_excel') ?></p>
    <?php endif; ?>
    <br><br>

    <button type="submit">Import Data</button>
    <a href="<?= base_url('admin/siswa') ?>" class="btn btn-primary">Kembali ke Daftar Siswa</a>
</form>
<?= $this->endSection() ?>