<?= $this->extend('layout/guru_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('success'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                <?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('error'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <form action="<?= base_url('guru/penilaian/index'); ?>" method="post">
                    <?= csrf_field(); ?>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="kelas_id">Kelas</label>
                                <select class="form-control" id="kelas_id" name="kelas_id" required>
                                    <option value="">-- Pilih Kelas --</option>
                                    <?php
                                    $unique_kelas = [];
                                    foreach ($guru_mapel_data as $gm) {
                                        if (!isset($unique_kelas[$gm['id_kelas']])) {
                                            $unique_kelas[$gm['id_kelas']] = $gm['nama_kelas'];
                                        }
                                    }
                                    ?>
                                    <?php foreach ($unique_kelas as $id_kelas => $nama_kelas) : ?>
                                        <option value="<?= esc($id_kelas); ?>" <?= ($selected_kelas_id == $id_kelas) ? 'selected' : ''; ?>>
                                            <?= esc($nama_kelas); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="mapel_id">Mata Pelajaran</label>
                                <select class="form-control" id="mapel_id" name="mapel_id" required>
                                    <option value="">-- Pilih Mapel --</option>
                                    <?php foreach ($guru_mapel_data as $gm) : ?>
                                        <option value="<?= esc($gm['mapel_id']); ?>" <?= ($selected_mapel_id == $gm['mapel_id']) ? 'selected' : ''; ?>>
                                            <?= esc($gm['nama_mapel']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="semester">Semester</label>
                                <select name="semester" class="form-control" required>
								<option value="">-- Pilih Semester --</option>
								<option value="1" <?= ($selected_semester == '1') ? 'selected' : ''; ?>>Ganjil</option>
								<option value="2" <?= ($selected_semester == '2') ? 'selected' : ''; ?>>Genap</option>
								</select>
                            </div>
                        </div>
                        <div class="col-md-3">
							<label>Tahun Ajaran</label>
							<select name="tahun_ajaran_id" class="form-control" required>
								<option value="">-- Pilih Tahun Ajaran --</option>
								<?php foreach ($tahun_ajaran as $ta) : ?>
									<option value="<?= $ta['id']; ?>" <?= ($ta['id'] == $selected_tahun_ajaran_id) ? 'selected' : ''; ?>>
										<?= $ta['nama_tahun']; ?>
									</option>
								<?php endforeach; ?>
							</select>
						</div>
                        <div class="col-md-1 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary mt-3">Tampilkan</button>
                        </div>
                    </div>
                </form>

                <?php if (!empty($data_siswa)) : ?>
                    <form action="<?= base_url('guru/penilaian/process'); ?>" method="post">
                        <?= csrf_field(); ?>
                        <input type="hidden" name="kelas_id" value="<?= esc($selected_kelas_id); ?>">
                        <input type="hidden" name="mapel_id" value="<?= esc($selected_mapel_id); ?>">
                        <input type="hidden" name="semester" value="<?= esc($selected_semester); ?>">
                        <input type="hidden" name="tahun_ajaran_id" value="<?= esc($selected_tahun_ajaran_id); ?>">

                        <div id="penilaian-table-container">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Nama Lengkap</th>
                                        <?php if (!empty($tp_mapel_list)) : ?>
                                            <th colspan="<?= count($tp_mapel_list); ?>" class="text-center">Nilai Harian (TP)</th>
                                        <?php endif; ?>
                                        <th>Nilai PTS/STS</th>
                                        <th>Nilai PAS/SAS</th>
                                    </tr>
                                    <tr>
                                        <th></th>
                                        <th></th>
                                        <?php if (!empty($tp_mapel_list)) : ?>
                                            <?php foreach ($tp_mapel_list as $tp) : ?>
                                                <th class="text-center" style="font-size: 10px;"><?= esc($tp['kode_tp']); ?></th>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                        <th></th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $no = 1; ?>
                                    <?php foreach ($data_siswa as $siswa) : ?>
                                        <tr>
                                            <td><?= $no++ ?></td>
                                            <td><?= esc($siswa['nama_lengkap']) ?></td>
                                            <?php if (!empty($tp_mapel_list)) : ?>
                                                <?php foreach ($tp_mapel_list as $tp) : ?>
                                                    <td>
                                                        <input type="text" class="form-control" name="nilai[<?= esc($siswa['id']); ?>][Harian][<?= esc($tp['id']); ?>]" value="<?= isset($data_penilaian[$siswa['id']]['harian'][$tp['id']]) ? esc($data_penilaian[$siswa['id']]['harian'][$tp['id']]) : ''; ?>">
                                                    </td>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                            <td>
                                                <input type="text" class="form-control" name="nilai[<?= esc($siswa['id']); ?>][PTS/STS]" value="<?= isset($data_penilaian[$siswa['id']]['pts']) ? esc($data_penilaian[$siswa['id']]['pts']) : ''; ?>">
                                            </td>
                                            <td>
                                                <input type="text" class="form-control" name="nilai[<?= esc($siswa['id']); ?>][PAS/SAS]" value="<?= isset($data_penilaian[$siswa['id']]['pas']) ? esc($data_penilaian[$siswa['id']]['pas']) : ''; ?>">
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <button type="submit" class="btn btn-primary mt-3">Simpan Nilai</button>
                    </form>
                    <hr>
                    <form action="<?= base_url('guru/penilaian/hitungNilaiAkhir'); ?>" method="get">
                        <input type="hidden" name="kelas_id" value="<?= esc($selected_kelas_id); ?>">
                        <input type="hidden" name="mapel_id" value="<?= esc($selected_mapel_id); ?>">
                        <input type="hidden" name="semester" value="<?= esc($selected_semester); ?>">
                        <input type="hidden" name="tahun_ajaran_id" value="<?= esc($selected_tahun_ajaran_id); ?>">
                        <button type="submit" class="btn btn-primary mt-3">Hitung Nilai Akhir</button>
                    </form>
                <?php endif; ?>
				<hr>
				<form action="<?= base_url('guru/penilaian/finalisasi') ?>" method="post" onsubmit="return confirm('Apakah Anda yakin ingin memfinalisasi semua nilai akhir rapor untuk semester ini? Proses ini akan menyimpan nilai secara permanen.');" style="display:inline;">
				<?= csrf_field(); ?>
				<button type="submit" class="btn btn-success mb-3">
				<i class="fas fa-check-circle"></i> Finalisasi Nilai Rapor
				</button>
				</form>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const kelasSelect = document.getElementById('kelas_id');
        const mapelSelect = document.getElementById('mapel_id');
        
        const guruMapelData = <?= json_encode($guru_mapel_data); ?>;

        function updateMapelOptions() {
            const selectedKelasId = kelasSelect.value;
            mapelSelect.innerHTML = '<option value="">-- Pilih Mata Pelajaran --</option>';

            const filteredMapels = guruMapelData.filter(item => item.id_kelas == selectedKelasId);
            
            const uniqueMapels = new Set();
            filteredMapels.forEach(item => {
                uniqueMapels.add(JSON.stringify({ id: item.mapel_id, nama_mapel: item.nama_mapel }));
            });

            Array.from(uniqueMapels).map(JSON.parse).sort((a, b) => a.nama_mapel.localeCompare(b.nama_mapel)).forEach(mapel => {
                const option = document.createElement('option');
                option.value = mapel.id;
                option.textContent = mapel.nama_mapel;
                
                if (mapel.id == '<?= esc($selected_mapel_id); ?>') {
                    option.selected = true;
                }
                mapelSelect.appendChild(option);
            });
        }

        if (kelasSelect.value) {
            updateMapelOptions();
        }

        kelasSelect.addEventListener('change', updateMapelOptions);
    });
</script>

<?= $this->endSection(); ?>