<?= $this->extend('layout/guru_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <a href="<?= base_url('guru/penilaian'); ?>" class="btn btn-secondary mb-3">Kembali</a>
                <table class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Siswa</th>
                            <th>Rerata Harian</th>
                            <th>Nilai PTS/STS</th>
                            <th>Nilai PAS/SAS</th>
                            <th>Nilai Akhir</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1; ?>
                        <?php foreach ($nilai_akhir_siswa as $nilai) : ?>
                            <tr>
                                <td><?= $no++ ?></td>
                                <td><?= esc($nilai['nama_siswa']) ?></td>
                                <td><?= esc($nilai['rerata_harian']) ?></td>
                                <td><?= esc($nilai['nilai_pts']) ?></td>
                                <td><?= esc($nilai['nilai_pas']) ?></td>
                                <td><strong><?= esc($nilai['nilai_akhir']) ?></strong></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>