<?php namespace App\Controllers\Guru;

use App\Controllers\BaseController;
use App\Models\GuruKokurikulerTemaModel;
use App\Models\GuruKokurikulerDetailModel; // BARU: Import Model Detail
use App\Models\TahunAjaranModel; // <--- PASTIKAN MODEL INI ADA
use App\Models\KelasModel; // <--- PASTIKAN MODEL INI ADA

class KokurikulerController extends BaseController
{
    protected $kokurikulerTemaModel;
    protected $kokurikulerDetailModel; // BARU: Properti untuk Model Detail
	protected $tahunAjaranModel; // BARU
    protected $kelasModel;       // BARU
    protected $dimensiList; // Daftar dimensi untuk dropdown

    public function __construct()
    {
        $this->kokurikulerTemaModel = new GuruKokurikulerTemaModel();
        $this->kokurikulerDetailModel = new GuruKokurikulerDetailModel(); // BARU: Inisialisasi Model Detail
		$this->tahunAjaranModel = new TahunAjaranModel(); // Inisialisasi
        $this->kelasModel = new KelasModel();             // Inisialisasi
        
        // Daftar Dimensi yang diminta
        $this->dimensiList = [
            'Keimanan dan Ketaqwaan terhadap Tuhan YME',
            'Kewargaan',
            'Penalaran Kritis',
            'Kreativitas',
            'Kolaborasi',
            'Kemandirian',
            'Kesehatan',
            'Komunikasi',
        ];
    }

    public function index()
	{
    $data['title'] = 'Manajemen Tema Kokurikuler';
    
    // 1. Dapatkan ID Pengguna yang Sedang Login (Pastikan kuncinya benar)
    $user_id = session()->get('user_id'); // Ganti 'id_user' jika kunci session Anda berbeda
    
    // 2. Cari Kelas yang Diampu Guru (Wali Kelas)
    $kelas_wali = $this->kelasModel
                        ->select('id_kelas, nama_kelas')
                        // Menggunakan kolom yang sudah dikoreksi: guru_kelas_id
                        ->where('guru_kelas_id', $user_id) 
                        ->first();
    
    // 3. Jika bukan Wali Kelas, hentikan dan kirim data kosong
    if (empty($kelas_wali)) {
        $data['list_tema'] = []; 
        $data['is_wali_kelas'] = false; // Gunakan flag ini di view jika perlu
        $data['tahun_ajaran'] = ['nama_tahun' => 'N/A'];
        return view('guru/kokurikuler/index', $data);
    }

    // 4. Dapatkan Tahun Ajaran Aktif (untuk filter)
    $tahun_ajaran_aktif = $this->tahunAjaranModel->where('aktif', 1)->first();
    
    $kelas_id = $kelas_wali['id_kelas'];
    $tahun_ajaran_id = $tahun_ajaran_aktif['id'] ?? null;
    
    // 5. Ambil Data Tema Kokurikuler yang Sesuai
    $query = $this->kokurikulerTemaModel
                    ->where('kelas_id', $kelas_id);
        
    // Filter berdasarkan Tahun Ajaran aktif (jika ada)
    if ($tahun_ajaran_id) {
        $query->where('tahun_ajaran_id', $tahun_ajaran_id);
        $data['tahun_ajaran'] = $tahun_ajaran_aktif; // Kirim data TA aktif
    } else {
        // Jika tidak ada TA aktif, tetap tampilkan, tapi pesan TA-nya menjadi umum
        $data['tahun_ajaran'] = ['nama_tahun' => 'Semua Tahun Ajaran']; 
    }

    // Eksekusi kueri dan kirim ke view
    $data['list_tema'] = $query->findAll();
    $data['is_wali_kelas'] = true;

    return view('guru/kokurikuler/index', $data);
	}

    public function create()
    {
        $data['title'] = 'Tambah Tema Kokurikuler';
        $data['dimensi_list'] = $this->dimensiList;
        
        // --- LOGIKA PENGAMBILAN DATA UNTUK DROPDOWN ---
        $data['tahun_ajaran_options'] = $this->tahunAjaranModel->findAll() ?? [];
        $data['semester_options'] = [1 => 'Ganjil', 2 => 'Genap'];
        
        // ASUMSI: Mendapatkan ID pengguna dari session. Sesuaikan 'id_user' jika berbeda.
        $user_id = session()->get('user_id'); 
        
        // Ambil data Kelas Wali Kelas
        $data['kelas_wali'] = $this->kelasModel
                                ->select('id_kelas, nama_kelas')
                                ->where('guru_kelas_id', $user_id) 
                                ->first();
                                
        // Set nilai default (misalnya tahun ajaran yang aktif)
        $data['tahun_ajaran_id_default'] = $this->tahunAjaranModel->where('aktif', 1)->first()['id'] ?? null;
        $data['kelas_id_default'] = $data['kelas_wali']['id_kelas'] ?? null;
        
        // --- END LOGIKA PENGAMBILAN DATA ---

        return view('guru/kokurikuler/create', $data);
    }
    
    public function save()
    {
        // 1. Validasi Input Header (Tambahkan validasi Semester)
        if (!$this->validate([
            'nama_kegiatan'   => 'required',
            'tahun_ajaran_id' => 'required', // Wajib ada
            'semester'        => 'required', // Wajib ada
            'tema_1_nama'     => 'required',
            'tema_2_nama'     => 'required',
            'tema_3_nama'     => 'required',
        ])) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        // 2. Simpan data header ke tabel kokurikuler_tema
        $temaHeaderData = [
            'tahun_ajaran_id' => $this->request->getPost('tahun_ajaran_id'),
            'kelas_id'        => $this->request->getPost('kelas_id'), // Dari hidden input
            'semester'        => $this->request->getPost('semester'), // BARU
            'nama_kegiatan'   => $this->request->getPost('nama_kegiatan'),
            'tema_1_nama'     => $this->request->getPost('tema_1_nama'),
            'tema_2_nama'     => $this->request->getPost('tema_2_nama'),
            'tema_3_nama'     => $this->request->getPost('tema_3_nama'),
        ];

        $this->kokurikulerTemaModel->insert($temaHeaderData);
        $tema_id = $this->kokurikulerTemaModel->getInsertID();

        // 3. Proses dan simpan data detail ke tabel kokurikuler_detail
        // ... (Logika menyimpan detail tetap sama) ...
        for ($i = 1; $i <= 3; $i++) {
            $dimensiArray = $this->request->getPost("dimensi_{$i}");
            $tujuanArray = $this->request->getPost("tujuan_{$i}");

            if (!empty($dimensiArray) && is_array($dimensiArray)) {
                foreach ($dimensiArray as $key => $dimensi) {
                    if (!empty($dimensi) && isset($tujuanArray[$key]) && !empty($tujuanArray[$key])) {
                        $detailData = [
                            'tema_id'             => $tema_id,
                            'nomor_tema'          => $i,
                            'dimensi'             => $dimensi,
                            'tujuan_pembelajaran' => $tujuanArray[$key], 
                        ];
                        $this->kokurikulerDetailModel->insert($detailData);
                    }
                }
            }
        }
        
        return redirect()->to(base_url('guru/kokurikuler'))->with('success', 'Tema Kokurikuler berhasil disimpan.');
    }
    
    public function edit($id = null)
	{
    if ($id === null) {
        return redirect()->to(base_url('guru/kokurikuler'))->with('error', 'ID tema tidak ditemukan.');
    }
    
    // 1. Ambil data Tema Header
    $tema = $this->kokurikulerTemaModel->find($id);
    if (!$tema) {
        return redirect()->to(base_url('guru/kokurikuler'))->with('error', 'Data tema kokurikuler tidak ditemukan.');
    }
    
    // 2. Ambil data Detail (Dimensi & Tujuan)
    // Asumsi: kolom Foreign Key di kokurikuler_detail adalah 'tema_id'
    $detail_list_raw = $this->kokurikulerDetailModel
                            ->where('tema_id', $id)
                            ->findAll();
                            
    // Kelompokkan data detail berdasarkan nomor_tema (1, 2, atau 3)
    $grouped_detail = [];
    foreach ($detail_list_raw as $detail) {
        $nomor = $detail['nomor_tema'];
        if (!isset($grouped_detail[$nomor])) {
            $grouped_detail[$nomor] = [];
        }
        $grouped_detail[$nomor][] = $detail;
    }

    // 3. Ambil data pendukung (Dropdown Options)
    $data['tahun_ajaran_options'] = $this->tahunAjaranModel->findAll() ?? [];
    $data['semester_options'] = [1 => 'Ganjil', 2 => 'Genap'];
    $data['dimensi_list'] = $this->dimensiList; 
    
    // 4. Ambil data Kelas Wali Kelas (hanya untuk ditampilkan)
    $user_id = session()->get('user_id'); 
    $data['kelas_wali'] = $this->kelasModel
                            ->select('id_kelas, nama_kelas')
                            ->where('guru_kelas_id', $user_id) 
                            ->first();

    // 5. Kirim semua data ke view
    $data['title'] = 'Edit Tema Kokurikuler';
    $data['tema'] = $tema; // Data header tema
    $data['grouped_detail'] = $grouped_detail; // Data detail yang sudah dikelompokkan
    
    return view('guru/kokurikuler/edit', $data);
	}
    
    public function update($id = null)
	{
    // Cek ID
    if ($id === null) {
        return redirect()->back()->with('error', 'ID tema tidak valid.');
    }
    
    // 1. Validasi Input (sama seperti save(), tapi tambahkan id)
    if (!$this->validate([
        'nama_kegiatan'   => 'required',
        'tahun_ajaran_id' => 'required', 
        'semester'        => 'required', 
        'tema_1_nama'     => 'required',
        'tema_2_nama'     => 'required',
        'tema_3_nama'     => 'required',
    ])) {
        return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
    }

    // 2. Siapkan Data Header untuk Update
    $temaHeaderData = [
        'tahun_ajaran_id' => $this->request->getPost('tahun_ajaran_id'),
        'kelas_id'        => $this->request->getPost('kelas_id'),       
        'semester'        => $this->request->getPost('semester'), 
        'nama_kegiatan'   => $this->request->getPost('nama_kegiatan'),
        'tema_1_nama'     => $this->request->getPost('tema_1_nama'), 
        'tema_2_nama'     => $this->request->getPost('tema_2_nama'), 
        'tema_3_nama'     => $this->request->getPost('tema_3_nama'), 
    ];

    // Lakukan update data header
    $this->kokurikulerTemaModel->update($id, $temaHeaderData);
    
    // 3. Hapus semua data detail lama sebelum menyimpan data baru
    // Ini adalah cara paling mudah untuk mengelola data detail yang dinamis (CRUD Detail)
    $this->kokurikulerDetailModel->where('tema_id', $id)->delete();

    // 4. Proses dan simpan data detail BARU ke tabel kokurikuler_detail
    for ($i = 1; $i <= 3; $i++) {
        $dimensiArray = $this->request->getPost("dimensi_{$i}");
        $tujuanArray = $this->request->getPost("tujuan_{$i}");

        if (!empty($dimensiArray) && is_array($dimensiArray)) {
            foreach ($dimensiArray as $key => $dimensi) {
                if (!empty($dimensi) && isset($tujuanArray[$key]) && !empty($tujuanArray[$key])) {
                    $detailData = [
                        'tema_id'             => $id, // ID Tema yang diupdate
                        'nomor_tema'          => $i,
                        'dimensi'             => $dimensi,
                        'tujuan_pembelajaran' => $tujuanArray[$key], 
                    ];
                    $this->kokurikulerDetailModel->insert($detailData);
                }
            }
        }
    }
    
    return redirect()->to(base_url('guru/kokurikuler'))->with('success', 'Tema Kokurikuler berhasil diperbarui.');
	}

    public function delete($id)
    {
        // Karena ada Foreign Key dengan ON DELETE CASCADE, menghapus tema_id akan otomatis menghapus detailnya.
        $this->kokurikulerTemaModel->delete($id);
        return redirect()->to(base_url('guru/kokurikuler'))->with('success', 'Tema Kokurikuler berhasil dihapus.');
    }
}