<?php

namespace App\Controllers\Guru;

use App\Controllers\BaseController;

class Ljk extends BaseController
{
    protected $db;

    public function __construct()
    {
        $this->db = \Config\Database::connect();
    }

    public function index()
    {
        // Kita ambil data kelas dan mapel sesuai tabel yang ada di database Anda
        // Jika namanya bukan 'kelas', ganti menjadi nama yang benar (misal: 'm_kelas')
        $data = [
            'title' => 'Generator LJK',
            'kelas' => $this->db->table('kelas')->get()->getResultArray(), 
            'mapel' => $this->db->table('mata_pelajaran')->get()->getResultArray(), // Ganti 'mapel' jadi 'mata_pelajaran' jika perlu
        ];
        return view('guru/ljk/index', $data);
    }

	public function getSiswa($id_kelas)
	{
		// Sesuaikan 'id_kelas' dan nama tabel 'siswa' dengan database Anda
		$siswa = $this->db->table('siswa')
					  ->where('kelas_id', $id_kelas)
					  ->orderBy('nama_lengkap', 'ASC')
					  ->get()->getResultArray();
					  
		if (empty($siswa)) {
        return $this->response->setJSON([['nama_lengkap' => 'Tidak ada siswa di kelas ini']]);
    }
					  
		return $this->response->setJSON($siswa);
	}

	public function kunci()
	{
		$db = \Config\Database::connect();
		
		// Coba ambil data dari tabel tahun_ajaran. 
		// Jika error lagi, cek nama tabel di phpMyAdmin (misal: m_tahun_ajaran)
		$tahun_ajaran = $db->table('tahun_ajaran')->where('aktif', '1')->get()->getResultArray();
		
		// Jika tabel tahun_ajaran kosong, kita ambil semua saja
		if(empty($tahun_ajaran)) {
			$tahun_ajaran = $db->table('tahun_ajaran')->get()->getResultArray();
		}

		$data = [
			'title' => 'Input Kunci Jawaban LJK',
			'kelas' => $db->table('kelas')->get()->getResultArray(),
			'mapel' => $db->table('mata_pelajaran')->get()->getResultArray(),
			'tahun_ajaran' => $tahun_ajaran,
		];
		return view('guru/ljk/input_kunci', $data);
	}
	
	public function simpan_kunci()
	{
		$db = \Config\Database::connect();

		// Ambil data dari form
		$kelas_id        = $this->request->getPost('kelas_id');
		$mapel_id        = $this->request->getPost('mapel_id');
		$tahun_ajaran_id = $this->request->getPost('tahun_ajaran_id');
		$semester        = $this->request->getPost('semester');
		$kunci_array     = $this->request->getPost('kunci'); // Ini berupa array [1=>'A', 2=>'B', ...]

		// Ubah array kunci menjadi JSON string
		$kunci_json = json_encode($kunci_array);

		// Cek apakah sudah ada kunci untuk kombinasi ini
		$existing = $db->table('ljk_kunci')->where([
			'kelas_id'        => $kelas_id,
			'mapel_id'        => $mapel_id,
			'tahun_ajaran_id' => $tahun_ajaran_id,
			'semester'        => $semester
		])->get()->getRow();

		$data = [
			'kelas_id'        => $kelas_id,
			'mapel_id'        => $mapel_id,
			'tahun_ajaran_id' => $tahun_ajaran_id,
			'semester'        => $semester,
			'kunci_json'      => $kunci_json,
			'created_at'      => date('Y-m-d H:i:s')
		];

		if ($existing) {
			// Jika sudah ada, kita Update
			$db->table('ljk_kunci')->where('id', $existing->id)->update($data);
			$pesan = "Kunci jawaban berhasil diperbarui!";
		} else {
			// Jika belum ada, kita Insert baru
			$db->table('ljk_kunci')->insert($data);
			$pesan = "Kunci jawaban berhasil disimpan!";
		}

		return redirect()->to(base_url('guru/ljk/kunci'))->with('success', $pesan);
	}

    public function cetak()
	{
		$nama_siswa  = $this->request->getPost('nama_siswa');
		$kelas_nama  = $this->request->getPost('kelas_nama');
		$id_kelas    = $this->request->getPost('kelas_id');

		// JIKA kelas_nama kosong dari form, ambil manual dari database berdasarkan ID
		if (empty($kelas_nama) && !empty($id_kelas)) {
			$db = \Config\Database::connect();
			$kelas = $db->table('kelas')->where('id_kelas', $id_kelas)->get()->getRow();
			$kelas_nama = ($kelas) ? $kelas->nama_kelas : '';
		}

		$data = [
			'nama_siswa'   => $nama_siswa,
			'kelas_nama'   => $kelas_nama,
			'mapel'        => $this->request->getPost('mapel'),
			'jumlah_soal'  => $this->request->getPost('jumlah_soal'),
		];

		return view('guru/ljk/cetak_template', $data);
	}
	
	public function scan()
	{
		$db = \Config\Database::connect();
		$data = [
			'title' => 'Scan LJK Siswa',
			'kelas' => $db->table('kelas')->get()->getResultArray(),
			'mapel' => $db->table('mata_pelajaran')->get()->getResultArray(),
		];
		return view('guru/ljk/scanner', $data);
	}

	// Fungsi untuk mengambil kunci jawaban via AJAX
	public function get_kunci($kelas_id, $mapel_id)
	{
		$db = \Config\Database::connect();
		$kunci = $db->table('ljk_kunci')
					->where('kelas_id', $kelas_id)
					->where('mapel_id', $mapel_id)
					->orderBy('id', 'DESC')
					->get()->getRowArray();
		
		return $this->response->setJSON($kunci);
	}
	
	public function hitung_nilai()
	{
		$json = $this->request->getJSON();
		$jawabanSiswa = $json->jawaban; 
		$namaMapel = $json->mapel;

		$db = \Config\Database::connect();

		// Ambil ID Mapel berdasarkan nama dari QR
		$mapel = $db->table('mapel')->where('nama_mapel', $namaMapel)->get()->getRow();

		if (!$mapel) {
			return $this->response->setJSON(['skor' => 'Err', 'msg' => 'Mapel tidak ditemukan']);
		}

		// Ambil kunci jawaban terbaru untuk mapel ini
		$kunci = $db->table('ljk_kunci')->where('mapel_id', $mapel->id)->get()->getRow();

		if (!$kunci) {
			return $this->response->setJSON(['skor' => 'Err', 'msg' => 'Kunci belum diatur']);
		}

		$kunciArray = json_decode($kunci->kunci_json, true);
		$benar = 0;
		$total = count($kunciArray);

		foreach ($kunciArray as $nomor => $jawabanBenar) {
			// Jawaban scan index 0-19 sesuai dengan nomor kunci 1-20
			if (isset($jawabanSiswa[$nomor-1]) && $jawabanSiswa[$nomor-1] == $jawabanBenar) {
				$benar++;
			}
		}

		$skor = ($total > 0) ? round(($benar / $total) * 100) : 0;

		return $this->response->setJSON([
			'status' => 'success',
			'skor'   => $skor,
			'benar'  => $benar
		]);
	}
	
	public function simpan_nilai()
	{
		$db = \Config\Database::connect();
		$data = [
			'nama_siswa' => $this->request->getPost('nama'),
			'mapel'      => $this->request->getPost('mapel'),
			'skor'       => $this->request->getPost('skor'),
			'tgl_ujian'  => date('Y-m-d H:i:s')
		];
		
		$db->table('nilai_ujian')->insert($data);
		return $this->response->setJSON(['status' => 'success']);
	}
}