<?php

namespace App\Models;

use CodeIgniter\Model;

class NilaiAsesmenMapelModel extends Model
{
    protected $table            = 'nilai_asesmen_mapel';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['siswa_id', 'tp_mapel_id', 'semester', 'tahun_ajaran_id', 'status_pencapaian', 'catatan_guru'];

    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules = [
        'siswa_id'          => 'required|is_natural_no_zero',
        'tp_mapel_id'       => 'required|is_natural_no_zero',
        'semester'          => 'required|in_list[1,2]',
        'tahun_ajaran_id'   => 'required|is_natural_no_zero',
        'status_pencapaian' => 'required|in_list[tercapai,perlu_bimbingan_lanjut,belum_dinilai]',
    ];
    protected $validationMessages = [];
    protected $skipValidation = false;
}