<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('title') ?><?= $title ?><?= $this->endSection() ?>

<?= $this->section('content') ?>
<h1><?= esc($title) ?></h1>
<p>Isi formulir di bawah ini untuk mengubah data kelas.</p>

<form action="<?= base_url('admin/kelas/update/' . $kelas['id_kelas']) ?>" method="post">
    <?= csrf_field() ?>
    
   <div class="form-group">
        <label for="nama_kelas">Nama Kelas</label>
        <input type="text" id="nama_kelas" name="nama_kelas"
               value="<?= old('nama_kelas', $kelas['nama_kelas']) ?>"
               class="form-control <?= ($validation->hasError('nama_kelas')) ? 'is-invalid' : ''; ?>" required>
        <?php if ($validation->hasError('nama_kelas')): ?>
            <div class="invalid-feedback">
                <?= $validation->getError('nama_kelas') ?>
            </div>
        <?php endif; ?>
    </div>
    
    <div class="form-group">
        <label for="guru_kelas_id">Guru Kelas</label>
        <select id="guru_kelas_id" name="guru_kelas_id" 
                class="form-control <?= ($validation->hasError('guru_kelas_id')) ? 'is-invalid' : ''; ?>">
            <option value="">-- Pilih Guru Kelas --</option>
            
            <?php foreach ($gurus as $guru) : ?>
                <option value="<?= esc($guru['id']) ?>" 
                        <?= (old('guru_kelas_id', $kelas['guru_kelas_id']) == $guru['id']) ? 'selected' : '' ?>>
                    <?= esc($guru['nama']) ?>
                </option>
            <?php endforeach; ?>
        </select>
        <?php if ($validation->hasError('guru_kelas_id')): ?>
            <div class="invalid-feedback">
                <?= $validation->getError('guru_kelas_id') ?>
            </div>
        <?php endif; ?>
    </div>

    <div class="form-group">
        <label for="tahun_ajaran_id">Tahun Ajaran</label>
        <select id="tahun_ajaran_id" name="tahun_ajaran_id" 
                class="form-control <?= ($validation->hasError('tahun_ajaran_id')) ? 'is-invalid' : ''; ?>" required>
            <option value="">-- Pilih Tahun Ajaran --</option>
            
            <?php foreach ($tahunAjaranList as $ta) : ?>
                <option value="<?= esc($ta['id']) ?>" 
                        <?= (old('tahun_ajaran_id', $kelas['tahun_ajaran_id']) == $ta['id']) ? 'selected' : '' ?>>
                    <?= esc($ta['nama_tahun']) ?>
                </option>
            <?php endforeach; ?>
        </select>
        <?php if ($validation->hasError('tahun_ajaran_id')): ?>
            <div class="invalid-feedback">
                <?= $validation->getError('tahun_ajaran_id') ?>
            </div>
        <?php endif; ?>
    </div>

    <button type="submit" class="btn btn-primary">Perbarui Kelas</button>
    </form>

<style>
    /* Styling sederhana untuk validasi error (jika belum ada di admin.css) */
    .is-invalid {
        border-color: #dc3545; /* Merah untuk input yang salah */
    }
    .text-danger {
        color: #dc3545;
        font-size: 0.875em;
        margin-top: 5px;
    }
</style>
<?= $this->endSection() ?>