<?= $this->extend('layout/guru_layout'); ?>
<?= $this->section('content'); ?>

<style>
    .btn-group-toggle .btn { margin-bottom: 5px; width: 45px; border-radius: 5px !important; margin-right: 5px; }
    .nomor-kunci { font-weight: bold; width: 40px; display: inline-block; }
    .card-kunci { border: 1px solid #ddd; padding: 15px; border-radius: 10px; background: #f9f9f9; }
</style>

<div class="row">
    <div class="col-12">
        <form action="<?= base_url('guru/ljk/simpan_kunci'); ?>" method="post">
            <?= csrf_field(); ?>
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h3 class="card-title">Setting Kunci Jawaban</h3>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <label>Kelas</label>
                            <select name="kelas_id" class="form-control" required>
                                <?php foreach($kelas as $k): ?>
                                    <option value="<?= $k['id_kelas']; ?>"><?= $k['nama_kelas']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label>Mata Pelajaran</label>
                            <select name="mapel_id" class="form-control" required>
                                <?php foreach($mapel as $m): ?>
                                    <option value="<?= $m['id']; ?>"><?= $m['nama_mapel']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label>Semester</label>
                            <select name="semester" class="form-control">
                                <option value="1">Ganjil</option>
                                <option value="2">Genap</option>
                            </select>
                        </div>
                        <div class="col-md-2">
							<label>Tahun Ajaran</label>
							<select name="tahun_ajaran_id" class="form-control" required>
								<?php foreach($tahun_ajaran as $ta): ?>
									<option value="<?= $ta['id']; ?>"><?= $ta['nama_tahun']; ?></option>
								<?php endforeach; ?>
							</select>
						</div>
						<div class="col-md-2">
                            <label>Jumlah Soal</label>
                            <select id="jml_soal" class="form-control" onchange="generateForm()">
                                <option value="20">20 Soal</option>
                                <option value="40">40 Soal</option>
                                <option value="50">50 Soal</option>
                            </select>
                        </div>
                    </div>

                    <div id="container-kunci" class="row">
                        </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-success btn-lg shadow">
                            <i class="fas fa-save mr-2"></i> Simpan Kunci Jawaban
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    function generateForm() {
        const jml = document.getElementById('jml_soal').value;
        const container = document.getElementById('container-kunci');
        container.innerHTML = '';

        for (let i = 1; i <= jml; i++) {
			let html = `
				<div class="col-md-4 col-sm-6 mb-3">
					<div class="card-kunci">
						<span class="nomor-kunci">${i}.</span>
						<div class="btn-group btn-group-toggle" data-toggle="buttons">
							${['A','B','C','D'].map(opt => `
								<label class="btn btn-outline-primary btn-sm">
									<input type="radio" name="kunci[${i}]" value="${opt}" required> ${opt}
								</label>
							`).join('')}
						</div>
					</div>
				</div>
			`;
            container.innerHTML += html;
        }
    }

    // Jalankan saat pertama kali dimuat
    document.addEventListener('DOMContentLoaded', generateForm);
</script>

<?= $this->endSection(); ?>