<?= $this->extend('layout/kokurikuler_layout'); ?> 

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success"><?= session()->getFlashdata('success'); ?></div>
                <?php endif; ?>
                <?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger"><?= session()->getFlashdata('error'); ?></div>
                <?php endif; ?>

                <?php if (empty($list_tema)) : ?>
                    <div class="alert alert-warning">Belum ada Tema Kokurikuler yang dibuat untuk kelas <?= esc($kelas_wali['nama_kelas'] ?? 'Anda'); ?> di tahun ajaran <?= esc($tahun_ajaran['nama_tahun'] ?? 'aktif'); ?>.</div>
                <?php else : ?>
                    <p>Pilih Tema Kokurikuler dari Kelas <strong><?= esc($kelas_wali['nama_kelas']); ?></strong> untuk diinput nilainya:</p>
                    
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Nama Kegiatan</th>
                                <th>Semester</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1; foreach ($list_tema as $tema) : ?>
                            <tr>
                                <td><?= $no++; ?></td>
                                <td><?= esc($tema['nama_kegiatan']); ?></td>
                                <td>Semester <?= esc($tema['semester']); ?></td>
                                <td>
                                    <a href="<?= base_url('guru/penilaian_kokurikuler/input/' . $tema['id']); ?>" class="btn btn-primary btn-sm">
                                        <i class="fas fa-edit"></i> Input/Edit Nilai
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>