<!DOCTYPE html>
<html>
<head>
    <title>Rapor Siswa</title>
    <style>
        body {
            font-family: 'Times New Roman', Times, serif;
            font-size: 11pt;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 100%;
            padding: 15mm 20mm;
            box-sizing: border-box;
        }
        .header, .footer {
            width: 100%;
        }
        .header {
            margin-bottom: 20px;
        }
        .header .logo {
            float: left;
            width: 100px;
            margin-right: 20px;
        }
        .header .school-info {
            overflow: hidden;
            text-align: center;
        }
        .header h1, .header h3 {
            margin: 0;
            padding: 0;
        }
        .divider {
            border-bottom: 2px solid black;
            margin: 10px 0;
        }
        .student-data {
            width: 100%;
            margin-top: 15px;
            margin-bottom: 25px;
        }
        .student-data table {
            width: 100%;
            border-collapse: collapse;
        }
        .student-data td {
            padding: 2px 0;
        }
        .section-title {
            font-size: 12pt;
            font-weight: bold;
            margin-bottom: 5px;
        }
        table.nilai, table.ekskul, table.kehadiran, table.catatan {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table.nilai th, table.nilai td, table.ekskul th, table.ekskul td, table.kehadiran th, table.kehadiran td {
            border: 1px solid black;
            padding: 5px;
        }
        table.nilai th, table.ekskul th {
            background-color: #f2f2f2;
            text-align: center;
        }
        table.kehadiran td {
            text-align: center;
        }
        .ttd {
            width: 100%;
            margin-top: 30px;
            display: flex;
            justify-content: space-between;
        }
        .ttd div {
            width: 30%;
            text-align: center;
        }
        .ttd .tempat-tanggal {
            text-align: left;
        }
        .ttd .nama-gelar {
            margin-top: 50px;
            border-bottom: 1px solid black;
            display: inline-block;
            padding: 0 5px;
        }
        .ttd .nip {
            margin-top: 5px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="logo">
                <img src="<?= base_url('assets/img/logo.png') ?>" alt="Logo Sekolah" style="width: 100%;">
            </div>
            <div class="school-info">
                <h3>RAPOR PESERTA DIDIK</h3>
                <h3><?= esc($sekolah['nama_sekolah']) ?></h3>
                <p>NPSN: <?= esc($sekolah['npsn']) ?></p>
                <p><?= esc($sekolah['alamat_sekolah']) ?></p>
            </div>
        </div>
        <div class="divider"></div>

        <div class="student-data">
            <table cellpadding="0" cellspacing="0">
                <tr>
                    <td style="width: 25%;">Nama Siswa</td>
                    <td style="width: 5%;">:</td>
                    <td style="width: 30%;"><?= esc($siswa['nama_lengkap']) ?></td>
                    <td style="width: 15%;">Kelas</td>
                    <td style="width: 5%;">:</td>
                    <td style="width: 20%;"><?= esc($kelas['nama_kelas']) ?></td>
                </tr>
                <tr>
                    <td>NISN</td>
                    <td>:</td>
                    <td><?= esc($siswa['nisn']) ?></td>
                    <td>Fase</td>
                    <td>:</td>
                    <td><?= esc($fase) ?></td>
                </tr>
                <tr>
                    <td>NIS</td>
                    <td>:</td>
                    <td><?= esc($siswa['nis']) ?></td>
                    <td>Tahun Ajaran</td>
                    <td>:</td>
                    <td><?= esc($tahunAjaran['tahun_ajaran']) ?></td>
                </tr>
                <tr>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td>Semester</td>
                    <td>:</td>
                    <td><?= esc($tahunAjaran['semester']) ?></td>
                </tr>
            </table>
        </div>

        <p class="section-title">A. Nilai Akademik</p>
        <table class="nilai">
            <thead>
                <tr>
                    <th rowspan="2" style="width: 5%;">No</th>
                    <th rowspan="2" style="width: 35%;">Mata Pelajaran</th>
                    <th colspan="2" style="width: 30%;">Pengetahuan dan Keterampilan</th>
                    <th rowspan="2" style="width: 30%;">Capaian Kompetensi</th>
                </tr>
                <tr>
                    <th style="width: 15%;">Nilai</th>
                    <th style="width: 15%;">Predikat</th>
                </tr>
            </thead>
            <tbody>
                <?php $no = 1; ?>
                <?php foreach ($nilaiMapel as $nilai) : ?>
                <tr>
                    <td style="text-align: center;"><?= $no++ ?></td>
                    <td><?= esc($nilai['nama_mapel']) ?></td>
                    <td style="text-align: center;"><?= esc($nilai['nilai_akhir']) ?></td>
                    <td style="text-align: center;"><?= esc($nilai['predikat']) ?></td>
                    <td><?= esc($nilai['deskripsi_nilai']) ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <p class="section-title">B. Kegiatan Ekstrakurikuler</p>
        <table class="ekskul">
            <thead>
                <tr>
                    <th style="width: 5%;">No</th>
                    <th style="width: 35%;">Kegiatan Ekstrakurikuler</th>
                    <th style="width: 60%;">Keterangan</th>
                </tr>
            </thead>
            <tbody>
                <?php $no = 1; ?>
                <?php if (!empty($ekstrakurikuler)) : ?>
                    <?php foreach ($ekstrakurikuler as $ekskul) : ?>
                    <tr>
                        <td style="text-align: center;"><?= $no++ ?></td>
                        <td><?= esc($ekskul['nama_ekskul']) ?></td>
                        <td><?= esc($ekskul['keterangan']) ?></td>
                    </tr>
                    <?php endforeach; ?>
                <?php else : ?>
                    <tr>
                        <td colspan="3" style="text-align: center;">Tidak ada data ekstrakurikuler.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <p class="section-title">C. Kehadiran</p>
        <table class="kehadiran">
            <thead>
                <tr>
                    <th style="width: 25%;">Sakit</th>
                    <th style="width: 25%;">Izin</th>
                    <th style="width: 25%;">Tanpa Keterangan</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?= esc($kehadiran['sakit'] ?? 0) ?> hari</td>
                    <td><?= esc($kehadiran['izin'] ?? 0) ?> hari</td>
                    <td><?= esc($kehadiran['alpha'] ?? 0) ?> hari</td>
                </tr>
            </tbody>
        </table>
        
        <p class="section-title">D. Catatan Wali Kelas</p>
        <table class="catatan">
            <tbody>
                <tr>
                    <td style="height: 50px; vertical-align: top; padding: 10px;">
                        <?= esc($catatan['catatan'] ?? '-') ?>
                    </td>
                </tr>
            </tbody>
        </table>

        <div class="ttd">
            <div class="wali-murid">
                <p>Mengetahui,</p>
                <p>Orang Tua/Wali</p>
                <br><br><br><br>
                <p class="nama-gelar">( ........................... )</p>
            </div>
            <div class="wali-kelas">
                <p>Wali Kelas,</p>
                <br><br><br><br>
                <p class="nama-gelar"><?= esc($waliKelas['nama']) ?></p>
                <p class="nip">NIP. <?= esc($waliKelas['nip'] ?? '-') ?></p>
            </div>
            <div class="kepala-sekolah">
                <p>Kepala Sekolah,</p>
                <br><br><br><br>
                <p class="nama-gelar"><?= esc($kepalaSekolah['nama']) ?></p>
                <p class="nip">NIP. <?= esc($kepalaSekolah['nip'] ?? '-') ?></p>
            </div>
        </div>
    </div>
</body>
</html>