<?php

namespace App\Models;

use CodeIgniter\Model;

class ProyekP5Model extends Model
{
    protected $table            = 'proyek_p5';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['nama_proyek', 'deskripsi_proyek', 'tahun_ajaran_id'];

    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules = [
        'nama_proyek'     => 'required|min_length[5]',
        'tahun_ajaran_id' => 'required|is_natural_no_zero',
    ];
    protected $validationMessages = [];
    protected $skipValidation = false;
}