<?= $this->extend('layout/admin_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
                <div class="card-tools">
				<a href="<?= base_url('admin/mata_pelajaran/new') ?>" class="btn btn-success mb-3">Tambah Mata Pelajaran Baru</a>
				</div>
				</div>
            <div class="card-body">
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('success'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
				<table class="table table-bordered table-hover" id="data_table">
					<thead>
						<tr>
							<th>No.</th>
							<th>Nama Mata Pelajaran</th>
							<th>Aksi</th>
						</tr>
					</thead>
					<tbody>
						<?php $no = 1; foreach ($daftarMataPelajaran as $mapel): ?>
							<tr>
								<td><?= $no++ ?></td>
								<td><?= esc($mapel['nama_mapel']) ?></td>
								<td>
									<a href="<?= base_url('admin/mata_pelajaran/edit/' . $mapel['id']) ?>" class="btn btn-primary btn-sm">Edit</a>
									<a href="<?= base_url('admin/mata_pelajaran/delete/' . $mapel['id']) ?>" class="btn btn-danger btn-sm" onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?')">Hapus</a>
								</td>
							</tr>
						<?php endforeach; ?>
						<?php if (empty($daftarMataPelajaran)): ?>
							<tr>
								<td colspan="3">Tidak ada data mata pelajaran.</td>
							</tr>
						<?php endif; ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?= $this->endSection() ?>