<?= $this->extend('layout/guru_layout') ?>

<?= $this->section('title') ?>Dashboard Guru<?= $this->endSection() ?>

<?= $this->section('content') ?>

<h1>Selamat Datang di Dashboard Guru</h1>

<p>Di sini Anda bisa mengelola nilai siswa, kehadiran, catatan wali kelas, dan mencetak rapor.</p>

<?php if (isset($kelas)): ?>
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h3 class="m-0 font-weight-bold text-primary">
                📊 Progres Finalisasi Nilai Kelas <?= esc($kelas['nama_kelas']) ?>
            </h3>
            <p class="m-0 text-muted">
                Tahun Ajaran: <?= esc($tahunAjaran['nama_tahun'] ?? 'N/A') ?> | Semester: <?= esc($tahunAjaran['semester'] ?? 'N/A') ?> | Tanggal Rapor: <?= esc($sekolah['tanggal_rapor'] ?? 'N/A') ?>
            </p>
        </div>
        
        <div class="card-body">
            
            <?php if (!empty($progressInputNilai) && $progressInputNilai[0]['total_siswa'] > 0): ?>
                
                <div class="d-flex justify-content-around align-items-center p-3 mb-4 bg-light rounded shadow-sm border">
                    
                    <div class="text-center">
                        <span class="d-block text-success font-weight-bold h4 mb-0"><?= esc($chartData['selesai'] ?? 0) ?></span>
                        <small class="text-success">Mapel Selesai Final</small>
                    </div>
                    
                    <div class="mx-3" style="height: 50px; border-left: 1px solid #ccc;"></div> 
                    
                    <div class="text-center">
                        <span class="d-block text-warning font-weight-bold h4 mb-0"><?= esc($chartData['belum_selesai'] ?? 0) ?></span>
                        <small class="text-warning">Mapel Belum Selesai</small>
                    </div>
                    
                    <div class="mx-3" style="height: 50px; border-left: 1px solid #ccc;"></div>
                    
                    <div class="text-center">
                        <span class="d-block text-info font-weight-bold h4 mb-0"><?= esc($progressInputNilai[0]['total_siswa']) ?></span>
                        <small class="text-info">Total Siswa Kelas</small>
                    </div>
                </div>
                <h6 class="font-weight-bold text-primary mb-3">Detail Progres Input Nilai per Mata Pelajaran</h6>

                <div class="table-responsive">
                    <table class="table table-hover table-striped" style="width: 100%;">
                        <thead>
                            <tr>
                                <th style="width: 5%;">No</th>
                                <th style="width: 30%;">Mata Pelajaran</th>
                                <th style="width: 45%;">Progres Input Nilai</th>
                                <th style="width: 20%; text-align: center;">Status Final</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1; ?>
                            <?php foreach ($progressInputNilai as $item): ?>
                                <?php
                                    // Tentukan URL link
                                    $mapelId = $item['id'] ?? 0; 
                                    $kelasId = $kelas['id_kelas'] ?? 0;
                                    $linkUrl = base_url("guru/penilaian/"); 
                                    
                                    // Tentukan warna progress bar berdasarkan persentase
                                    $progressClass = 'bg-danger'; 
                                    $badgeClass = 'bg-danger';
                                    if ($item['persentase'] == 100) {
                                        $progressClass = 'bg-success';
                                        $badgeClass = 'bg-success';
                                    } elseif ($item['persentase'] > 0) {
                                        $progressClass = 'bg-info';
                                        $badgeClass = 'bg-info';
                                    }
                                ?>
                                
                                <tr onclick="window.location='<?= $linkUrl ?>';" style="cursor: pointer;">
                                    <td><?= $no++ ?></td>
                                    <td><?= esc($item['nama_mapel']) ?></td>
                                    
                                    <td>
                                        <div class="progress" style="height: 25px;">
                                            <div class="progress-bar <?= $progressClass ?>" 
                                                role="progressbar" 
                                                style="width: <?= $item['persentase'] ?>%;" 
                                                aria-valuenow="<?= $item['persentase'] ?>" 
                                                aria-valuemin="0" 
                                                aria-valuemax="100">
                                                <span class="font-weight-bold"><?= $item['persentase'] ?>%</span>
                                            </div>
                                        </div>
                                    </td>
                                    
                                    <td style="text-align: center;">
                                        <?php if ($item['persentase'] == 100): ?>
                                            <span class="badge <?= $badgeClass ?> p-2">Selesai Final</span>
                                        <?php else: ?>
                                            <span class="badge <?= $badgeClass ?> p-2">
                                                <?= $item['nilai_tersimpan_final_count'] ?>/<?= $item['total_siswa'] ?> Final
                                            </span>
                                        <?php endif; ?>
                                        <br>
                                        <small class="text-muted">(<?= esc($item['status_teks']) ?>)</small>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

            <?php else: ?>
                <div class="alert alert-info">
                    Anda belum ditugaskan sebagai wali kelas atau belum ada data siswa untuk kelas ini.
                </div>
            <?php endif; ?>

        </div>
    </div>
<?php endif; ?>
<?= $this->endSection() ?>