<?= $this->extend('layout/guru_layout'); ?>

<?= $this->section('content'); ?>
<link rel="stylesheet" href="<?= base_url('assets/css/rapor_cover.css'); ?>">
<style>
    .page-preview {
        border: 1px solid #ddd;
        padding: 20px;
        margin-bottom: 20px;
        background-color: #fff;
    }
    .page-break {
        height: 20px;
        border-bottom: 1px dashed #ccc;
        margin: 20px 0;
    }
	.rapor-petunjuk-preview {
        /* Properti kunci untuk mempertahankan spasi dan baris baru */
        white-space: pre-wrap; 
        /* Meningkatkan keterbacaan */
        line-height: 1.5;
        font-family: monospace; /* Opsional: kadang membantu keterapian indentasi */
    }
    /* START: STYLING BARU UNTUK IFRAME */
    .preview-container {
        /* Tambahkan text-align: center untuk menengahkan iframe yang fixed-width */
        text-align: center; 
        border: 1px solid #ddd;
        border-radius: 4px; 
        overflow: hidden;
        margin-top: 15px;
    }
    
    iframe.rapor-preview-iframe {
        width: 210mm;         /* Kunci: Atur lebar iframe fixed ke A4 */
        max-width: 100%;      /* Agar responsif jika layar lebih kecil */
        height: 800px; 
        border: none;
        box-shadow: 0 0 8px rgba(0,0,0,0.1); /* Opsional: beri efek kertas */
    }
    /* END: STYLING BARU UNTUK IFRAME */
</style>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('error'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('success'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <?php if (!empty($kelas)) : ?>
                    <div class="alert alert-info">
                        Anda adalah wali kelas : <strong><?= esc($kelas['nama_kelas']); ?></strong>
                    </div>
                
                    <form action="<?= base_url('guru/rapor_cover'); ?>" method="post">
                        <?= csrf_field(); ?>
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="tahun_ajaran_id">Tahun Ajaran</label>
                                    <select class="form-control" id="tahun_ajaran_id" name="tahun_ajaran_id" required>
                                        <option value="">-- Pilih Tahun Ajaran --</option>
                                        <?php foreach ($tahun_ajaran as $ta) : ?>
                                            <option value="<?= esc($ta['id']); ?>" <?= ($selected_tahun_ajaran_id == $ta['id']) ? 'selected' : ''; ?>>
                                                <?= esc($ta['nama_tahun']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="siswa_id">Pilih Siswa</label>
                                    <select class="form-control" id="siswa_id" name="siswa_id" required>
                                        <option value="">-- Pilih Siswa --</option>
                                        <?php foreach ($siswa_list as $siswa) : ?>
                                            <option value="<?= esc($siswa['id']); ?>" <?= ($selected_siswa_id == $siswa['id']) ? 'selected' : ''; ?>>
                                                <?= esc($siswa['nama_lengkap']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4 d-flex align-items-end">
                                <button type="submit" class="btn btn-success btn-sm">Tampilkan Pratinjau</button>
                            </div>
                        </div>
                    </form>

                    <?php if (!empty($selected_siswa)) : ?>
                        <hr>
                       
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Cetak Cover Rapor untuk <?= esc($selected_siswa['nama_lengkap']); ?></h4>
                                <div class="card-tools">
                                    <form action="<?= base_url('guru/rapor_cover/generate_pdf'); ?>" method="post">
                                        <?= csrf_field(); ?>
                                        <input type="hidden" name="siswa_id" value="<?= esc($selected_siswa['id']); ?>">
                                        <input type="hidden" name="tahun_ajaran_id" value="<?= esc($selected_tahun_ajaran_id); ?>">
                                        <button type="submit" class="btn btn-success btn-sm">Cetak PDF</button>
                                    </form>
                                </div>
                            </div>
                        </div>
						
                        <div class="card mt-3">
                            <div class="card-header">
                                <h3 class="card-title mb-0">Pratinjau Cover Rapor</h3>
                            </div>
                            <div class="card-body p-0 preview-container">
                                <iframe 
                                    src="<?= base_url('guru/rapor_cover/preview/' . $selected_siswa['id'] . '/' . $selected_tahun_ajaran_id); ?>"
                                    class="rapor-preview-iframe"
                                >
                                </iframe>
                            </div>
                        </div>
                        <?php else: ?>
                        <div class="alert alert-warning mt-3">Silakan pilih tahun ajaran dan siswa untuk menampilkan pratinjau.</div>
                    <?php endif; ?>

                <?php else: ?>
                    <div class="alert alert-danger">Anda tidak ditugaskan sebagai wali kelas. Fitur ini hanya dapat diakses oleh wali kelas.</div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>