<?= $this->extend('layout/guru_layout') ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
                <div class="card-tools">

				<?php if (!empty($message)) : ?>
					<div class="alert alert-info"><?= esc($message) ?></div>
				<?php endif; ?>

				<?php if (empty($siswa)) : ?>
					<p>Tidak ada siswa ditemukan di kelas yang Anda ajar.</p>
				<?php else : ?>
					<p>Anda mengajar kelas:
						<?php foreach ($kelas as $kls) : ?>
							<strong><?= esc($kls['nama_kelas']) ?></strong>
							<?php if (next($kelas)) : ?>, <?php endif; ?>
						<?php endforeach; ?>
					</p>
				</div>
				</div>
				<div class="card-body">
				<?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('success'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
        <table class="table table-bordered table-hover" id="data_table">
            <thead>
                <tr>
                    <th>No.</th>
                    <th>NISN</th>
                    <th>NIS</th>
                    <th>Nama Lengkap</th>
                    <th>Kelas</th>
                    <th>Tempat Lahir</th>
                    <th>Tanggal Lahir</th>
                    </tr>
            </thead>
            <tbody>
                <?php $no = 1; ?>
                <?php foreach ($siswa as $s) : ?>
                    <tr>
                        <td><?= $no++ ?></td>
                        <td><?= esc($s['nisn']) ?></td>
                        <td><?= esc($s['nis']) ?></td>
                        <td><?= esc($s['nama_lengkap']) ?></td>
                        <td><?= esc($s['nama_kelas']) ?></td>
                        <td><?= esc($s['tempat_lahir']) ?></td>
                        <td><?= esc($s['tanggal_lahir']) ?></td>
                        </tr>
						<?php endforeach; ?>
					</tbody>
				</table>
			<?php endif; ?>
			</div>
		</div>
	</div>
</div>
<?= $this->endSection() ?>