<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\MataPelajaranModel; // Import Model Mata Pelajaran

class MataPelajaran extends BaseController
{
    protected $mataPelajaranModel;

    public function __construct()
    {
        $this->mataPelajaranModel = new MataPelajaranModel();
    }

    public function index()
    {
        // Ambil semua data mata pelajaran dari database
        $daftarMataPelajaran = $this->mataPelajaranModel->findAll();

        $data = [
            'title'                 => 'Manajemen Mata Pelajaran',
            'daftarMataPelajaran'   => $daftarMataPelajaran // Data yang akan dilewatkan ke view
        ];

        // Memuat view index untuk Mata Pelajaran
        return view('admin/mata_pelajaran/index', $data);
    }

    public function create()
    {
        $data = [
            'title'      => 'Tambah Mata Pelajaran Baru',
            'validation' => \Config\Services::validation() // Untuk validasi
        ];
        return view('admin/mata_pelajaran/create', $data);
    }

    public function store()
    {
        // Aturan validasi
        if (!$this->validate([
            'nama_mapel' => [
                'rules'  => 'required|min_length[3]|is_unique[mata_pelajaran.nama_mapel]',
                'errors' => [
                    'required'    => 'Nama Mata Pelajaran harus diisi.',
                    'min_length'  => 'Nama Mata Pelajaran minimal 3 karakter.',
                    'is_unique'   => 'Nama Mata Pelajaran ini sudah ada.'
                ]
            ],
        ])) {
            return redirect()->back()->withInput()->with('validation', $this->validator);
        }

        $this->mataPelajaranModel->save([
            'nama_mapel' => $this->request->getVar('nama_mapel'),
        ]);

        session()->setFlashdata('success', 'Data mata pelajaran berhasil ditambahkan.');
        return redirect()->to(base_url('admin/mata_pelajaran'));
    }

    public function edit($id) // Parameter ID sesuai primaryKey
    {
        $mataPelajaran = $this->mataPelajaranModel->find($id);

        if (empty($mataPelajaran)) {
            session()->setFlashdata('error', 'Data mata pelajaran tidak ditemukan.');
            return redirect()->to(base_url('admin/mata_pelajaran'));
        }

        $data = [
            'title'         => 'Edit Mata Pelajaran',
            'validation'    => \Config\Services::validation(),
            'mataPelajaran' => $mataPelajaran
        ];
        return view('admin/mata_pelajaran/edit', $data);
    }

    public function update($id) // Parameter ID sesuai primaryKey
    {
        // Aturan validasi untuk update (mengabaikan data yang sedang diedit)
        $namaMapelRule = 'required|min_length[3]|is_unique[mata_pelajaran.nama_mapel,id,' . $id . ']';

        if (!$this->validate([
            'nama_mapel' => [
                'rules'  => $namaMapelRule,
                'errors' => [
                    'required'    => 'Nama Mata Pelajaran harus diisi.',
                    'min_length'  => 'Nama Mata Pelajaran minimal 3 karakter.',
                    'is_unique'   => 'Nama Mata Pelajaran ini sudah ada.'
                ]
            ],
        ])) {
            return redirect()->back()->withInput()->with('validation', $this->validator);
        }

        $this->mataPelajaranModel->update($id, [
            'nama_mapel' => $this->request->getVar('nama_mapel'),
        ]);

        session()->setFlashdata('success', 'Data mata pelajaran berhasil diperbarui.');
        return redirect()->to(base_url('admin/mata_pelajaran'));
    }

    public function delete($id) // Parameter ID sesuai primaryKey
    {
        $this->mataPelajaranModel->delete($id);
        session()->setFlashdata('success', 'Data mata pelajaran berhasil dihapus.');
        return redirect()->to(base_url('admin/mata_pelajaran'));
    }
}