<?= $this->extend('layout/guru_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('error'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('success'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <?php if (!empty($kelas)) : ?>
                    <div class="alert alert-info">
                        Anda sebagai guru kelas <strong><?= esc($kelas['nama_kelas']); ?></strong>.
                    </div>
                    <form action="<?= base_url('guru/catatan_wali_kelas'); ?>" method="post">
                        <?= csrf_field(); ?>
                        <input type="hidden" name="kelas_id" value="<?= esc($kelas['id_kelas']); ?>">
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="semester">Semester</label>
                                    <select class="form-control" id="semester" name="semester" required>
                                        <option value="">-- Pilih Semester --</option>
                                        <option value="1" <?= ($selected_semester == '1') ? 'selected' : ''; ?>>1</option>
                                        <option value="2" <?= ($selected_semester == '2') ? 'selected' : ''; ?>>2</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="tahun_ajaran_id">Tahun Ajaran</label>
                                    <select class="form-control" id="tahun_ajaran_id" name="tahun_ajaran_id" required>
                                        <option value="">-- Pilih Tahun Ajaran --</option>
                                        <?php foreach ($tahun_ajaran as $ta) : ?>
                                            <option value="<?= esc($ta['id']); ?>" <?= ($selected_tahun_ajaran_id == $ta['id']) ? 'selected' : ''; ?>>
                                                <?= esc($ta['nama_tahun']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary mb-3">Tampilkan</button>
                            </div>
                        </div>
                    </form>

                    <?php if (!empty($siswa_list)) : ?>
                        <form action="<?= base_url('guru/catatan_wali_kelas/save'); ?>" method="post">
                            <?= csrf_field(); ?>
                            <input type="hidden" name="semester" value="<?= esc($selected_semester); ?>">
                            <input type="hidden" name="tahun_ajaran_id" value="<?= esc($selected_tahun_ajaran_id); ?>">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Nama Siswa</th>
                                        <th>Catatan Umum</th>
                                        <th>Saran-saran</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $no = 1; ?>
                                    <?php foreach ($siswa_list as $siswa) : ?>
                                        <tr>
                                            <td><?= $no++; ?></td>
                                            <td><?= esc($siswa['nama_lengkap']); ?></td>
                                            <td>
                                                <input type="hidden" name="siswa_id[]" value="<?= esc($siswa['id']); ?>">
                                                <textarea name="catatan_umum[<?= esc($siswa['id']); ?>]" class="form-control" rows="3"><?= esc($catatan_data[$siswa['id']]['catatan_umum'] ?? ''); ?></textarea>
                                            </td>
                                            <td>
                                                <textarea name="saran_saran[<?= esc($siswa['id']); ?>]" class="form-control" rows="3"><?= esc($catatan_data[$siswa['id']]['saran_saran'] ?? ''); ?></textarea>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                            <button type="submit" class="btn btn-primary mt-3">Simpan Catatan</button>
                        </form>
                    <?php else: ?>
                        <div class="alert alert-warning mt-3">Silakan pilih semester dan tahun ajaran untuk menampilkan siswa.</div>
                    <?php endif; ?>

                <?php else: ?>
                    <div class="alert alert-danger">Anda tidak ditugaskan sebagai wali kelas. Fitur ini hanya dapat diakses oleh wali kelas.</div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>