<!DOCTYPE html>
<html>
<head>
    <title>Leger Nilai</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10pt;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 100%;
            padding: 10mm 15mm 10mm 0mm;
            box-sizing: border-box;
        }
        .header {
            text-align: center;
            margin-bottom: 10px;
        }
        .header h2, .header h3 {
            margin: 0;
            padding: 0;
        }
        table.data-leger {
            width: 100%;
            border-collapse: collapse;
            font-size: 9pt;
        }
        table.data-leger th, table.data-leger td {
            border: 1px solid black;
            padding: 5px;
            text-align: center;
        }
        table.data-leger th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .text-left {
            text-align: left;
        }
        
        /* Gaya untuk tabel tanda tangan yang baru */
        .ttd-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        .ttd-table td {
            border: none;
            padding: 5px;
            text-align: center;
            vertical-align: top;
        }
        .nama-gelar {
            margin-top: 60px;
            border-bottom: 1px solid black;
            display: inline-block;
            padding: 0 5px;
            margin-bottom: 0px;
        }
        .nip {
            margin-top: 0px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>LEGER NILAI</h2>
            <h3>Kelas: <?= esc($kelas['nama_kelas']) ?> | Tahun Ajaran: <?= esc($tahunAjaran['nama_tahun']) ?></h3>
        </div>
        <table class="data-leger">
            <thead>
                <tr>
                    <th rowspan="2" style="width: 5%;">No</th>
                    <th rowspan="2" style="width: 25%;">Nama Siswa</th>
                    <th colspan="<?= count($mapelList) ?>">Nilai Akhir Mata Pelajaran</th>
                    <th rowspan="2" style="width: 5%;">Total</th>
                    <th rowspan="2" style="width: 5%;">Rerata</th>
                    <th rowspan="2" style="width: 5%;">Peringkat</th>
                </tr>
                <tr>
                    <?php foreach ($mapelList as $mapel) : ?>
                        <th><?= esc($mapel['nama_mapel']) ?></th>
                    <?php endforeach; ?>
                </tr>
            </thead>
            <tbody>
                <?php $no = 1; ?>
                <?php foreach ($dataLeger as $siswaData) : ?>
                    <tr>
                        <td><?= $no++ ?></td>
                        <td style="text-align: left;"><?= esc($siswaData['siswa']['nama_lengkap']) ?></td>
                        <?php foreach ($mapelList as $mapel) : ?>
                            <td><?= esc($siswaData['nilai_mapel'][$mapel['id']] ?? '-') ?></td>
                        <?php endforeach; ?>
                        <td><?= esc($siswaData['total_nilai']) ?></td>
                        <td><?= esc($siswaData['rerata']) ?></td>
                        <td><?= esc($siswaData['peringkat']) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <table class="ttd-table">
            <tr>
                <td style="width: 60%;"></td> <td style="width: 40%;">
					<p><?= esc(tanggal_indonesia(date('d F Y', strtotime($sekolah['tanggal_rapor'] ?? date('Y-m-d'))))); ?></p>
					<p>Guru Kelas,</p>
                    <p class="nama-gelar"><?= esc($waliKelas['nama']) ?></p>
                    <p class="nip">NIP. <?= esc($waliKelas['nip'] ?? '-') ?></p>
                </td>
            </tr>
        </table>
    </div>
</body>
</html>
