<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $this->renderSection('title') ? 'Guru | ' . $this->renderSection('title') : 'Guru Dashboard'; ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link rel="stylesheet" href="<?= base_url('css/guru.css') ?>">

    <style>
        /* Asumsi lebar default sidebar dari css/guru.css adalah 250px */
        :root {
            --sidebar-width-normal: 250px;
            --sidebar-width-minimized: 75px;
            --transition-speed: 0.3s;
        }

        /* Tentukan transisi pada elemen layout utama */
        aside, main, header {
            transition: all var(--transition-speed);
        }

        /* Default state (Normal Sidebar) */
        aside {
            width: var(--sidebar-width-normal);
        }

        main {
            margin-left: var(--sidebar-width-normal);
        }
        
        /* Modifikasi Struktur sidebar-header */
        .sidebar-header {
            padding: 5px;
            border-bottom: 1px solid #444;
            padding-bottom: 5px; /* PASTIKAN padding-bottom di sini juga kecil atau 0 */
            margin-bottom: 0; /* TAMBAHKAN ATAU PASTIKAN INI ADA */
            /* Hapus display: flex agar elemen di dalamnya bisa stack vertikal */
        }
        
        /* Wrapper untuk Title dan Toggle Button agar tetap horizontal */
        .title-and-toggle {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px; /* Jarak antara Title/Toggle dengan User Panel */
        }

        .sidebar-toggle-btn {
            background: none;
            border: none;
            color: #fff; 
            font-size: 1em;
            cursor: pointer;
            padding: 5px;
            line-height: 1;
        }
        
        /* User Panel Styling: Pastikan teks Halo, Sdr/i. tetap terlihat */
        .user-panel .info {
            line-height: 1.2;
        }
        
        /* State Ketika Sidebar Diminimalkan (diterapkan pada body) */
        body.sidebar-minimized aside {
            width: var(--sidebar-width-minimized);
        }

        body.sidebar-minimized main {
            margin-left: var(--sidebar-width-minimized);
        }

        /* Sembunyikan Judul dan User Panel saat minimal */
        body.sidebar-minimized .sidebar-header h5,
        body.sidebar-minimized .user-panel {
            display: none !important;
        }
        
        /* Posisikan tombol toggle di tengah saat sidebar minimal */
        body.sidebar-minimized .sidebar-header {
            padding: 15px 0; /* Sesuaikan padding vertikal saat minimal */
            text-align: center;
        }
        
        /* Pastikan hanya tombol toggle yang terlihat di mode minimal */
        body.sidebar-minimized .title-and-toggle {
            justify-content: center;
        }
        
        /* Sembunyikan Teks pada Link Menu Sidebar */
        body.sidebar-minimized .sidebar-menu li a span {
            display: none;
        }

        /* Atur ulang Link Menu Sidebar agar ikon di tengah */
        body.sidebar-minimized .sidebar-menu li a {
            text-align: center;
            padding-left: 0;
            padding-right: 0;
            justify-content: center;
        }
        
        /* Hapus margin ikon agar ikon berada di tengah */
        body.sidebar-minimized .sidebar-menu li a i {
            margin-right: 0;
        }
    </style>
</head>

<body id="guru-layout">

    <header>
        <nav>
            <ul class="header-nav">
                <li><a href="<?= base_url('guru/dashboard') ?>"><i class="fas fa-home"></i> <span>Guru</span></a></li>
                <li><a href="<?= base_url('guru/profile') ?>"><i class="fas fa-user-circle"></i> <span>Profil</span></a></li>
                <li><a href="<?= base_url('guru/siswa') ?>"><i class="fas fa-user-graduate"></i> <span>Siswa Kelas Saya</span></a></li>
                <li><a href="<?= base_url('guru/siswa/naikKelas') ?>"><i class="fas fa-level-up-alt"></i> <span>Naik Kelas</span></a></li>
				<li><a href="<?= base_url('guru/kokurikuler') ?>"><i class="fas fa-project-diagram"></i> <span>Kokorikuler</span></a></li>
                <li><a href="<?= base_url('logout') ?>"><i class="fas fa-sign-out-alt"></i> <span>Logout</span></a></li>
            </ul>
        </nav>
    </header>

    <aside id="sidebar">
        <div class="sidebar-header">
            <div class="title-and-toggle">
                <h5><a href="#" class="sidebar-title">E-Raport SDN Degung</a></h5>
                <button id="sidebarToggle" class="sidebar-toggle-btn" title="Minimalkan Sidebar">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
            
            <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                <div class="info">
                    <span class="d-block" style="color: #72c17e;">
                        <strong>Halo, Sdr/i. <?= esc(session()->get('nama')); ?></strong>
                    </span>
                </div>
            </div>
            
        </div>
        
        <ul class="sidebar-menu">
            <li><a href="<?= base_url('guru/tp_mapel') ?>"><i class="fas fa-clipboard-list"></i> <span>Manajemen TP Mapel</span></a></li>
            <li><a href="<?= base_url('guru/penilaian') ?>"><i class="fas fa-edit"></i> <span>Input Nilai</span></a></li>
            <li><a href="<?= base_url('guru/rapor_cover') ?>"><i class="fas fa-book"></i> <span>Cover Raport</span></a></li>
            <li><a href="<?= base_url('guru/penilaian/deskripsi') ?>"><i class="fas fa-file-alt"></i> <span>Deskripsi Mapel</span></a></li>
			<li><a href="<?= base_url('guru/penilaian/nilaiAkhirRapor') ?>"><i class="nav-icon fas fa-file-invoice"></i> <span>Nilai Akhir Rapor</span></a></li>
            <li><a href="<?= base_url('guru/kehadiran') ?>"><i class="fas fa-user-check"></i> <span>Kehadiran</span></a></li>
            <li><a href="<?= base_url('guru/ekskul_wali_kelas') ?>"><i class="fas fa-running"></i> <span>Ekstrakurikuler</span></a></li>
            <li><a href="<?= base_url('guru/catatan_wali_kelas') ?>"><i class="fas fa-comment-dots"></i> <span>Catatan Wali Kelas</span></a></li>
            <li><a href="<?= base_url('guru/rapor') ?>"><i class="fas fa-print"></i> <span>Cetak Rapor</span></a></li>
        </ul>
    </aside>

    <main id="main-content">
        <div class="content">
            <?= $this->renderSection('content') ?>
        </div>
        <footer>
            <p>&copy; <?= date('Y'); ?> E-Raport SDN Degung. All rights reserved.</p>
        </footer>
    </main>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <script>
        $(document).ready(function() {
            // Cek status sidebar dari local storage saat halaman dimuat
            if (localStorage.getItem('sidebarState') === 'minimized') {
                $('body').addClass('sidebar-minimized');
            }

            $('#sidebarToggle').on('click', function(e) {
                e.preventDefault();
                
                // Toggle class pada body
                $('body').toggleClass('sidebar-minimized');
                
                // Simpan status ke local storage
                if ($('body').hasClass('sidebar-minimized')) {
                    localStorage.setItem('sidebarState', 'minimized');
                } else {
                    localStorage.setItem('sidebarState', 'normal');
                }
            });
        });
    </script>
</body>
</html>