<?= $this->extend('layout/kokurikuler_layout'); ?> 

<?= $this->section('content'); ?>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger"><?= session()->getFlashdata('error'); ?></div>
                <?php endif; ?>

                <p>Tema: <strong><?= esc($tema['nama_kegiatan']); ?></strong> (Kelas: <?= esc($tema['kelas_id']); ?>, Semester: <?= esc($tema['semester']); ?>)</p>
                <p>Rubrik Nilai: 1=Kurang, 2=Cukup, 3=Baik, 4=Sangat Baik</p>
                
                <form action="<?= base_url('guru/penilaian_kokurikuler/store'); ?>" method="post">
                    <?= csrf_field(); ?>
                    <input type="hidden" name="tema_id" value="<?= esc($tema['id']); ?>">

                    <div style="overflow-x: auto; max-width: 100%;"> 
                        
                        <table class="table table-bordered table-sm text-center" style="min-width: 700px; margin-bottom: 0;">
                            <thead>
                                <tr>
                                    <th rowspan="2" style="width: 50px; position: sticky; left: 0; background-color: #f8f9fa; z-index: 10;">No</th>
                                    <th rowspan="2" style="width: 250px; position: sticky; left: 50px; background-color: #f8f9fa; z-index: 10;" class="text-left">Nama Siswa</th>
                                    
                                    <?php 
                                    $dimensi_per_tema = [];
                                    foreach ($detail_tema as $detail) {
                                        $nomor_tema = $detail['nomor_tema'];
                                        if (!isset($dimensi_per_tema[$nomor_tema])) {
                                            $dimensi_per_tema[$nomor_tema] = [];
                                        }
                                        $dimensi_per_tema[$nomor_tema][] = $detail;
                                    }
                                    
                                    foreach ($dimensi_per_tema as $nomor => $details) : 
                                        $tema_nama_key = 'tema_' . $nomor . '_nama';
                                        $colspan = count($details);
                                    ?>
                                        <th colspan="<?= esc($colspan); ?>" class="bg-primary text-white" style="min-width: 200px; border-right: 3px solid #fff;">
                                            Tema <?= esc($nomor); ?>: <?= esc($tema[$tema_nama_key] ?? 'N/A'); ?>
                                        </th>
                                    <?php endforeach; ?>
                                </tr>
                                <tr>
                                    <?php foreach ($dimensi_per_tema as $nomor => $details) : ?>
                                        <?php foreach ($details as $detail) : ?>
                                            <th style="min-width: 100px; height: 70px; vertical-align: middle; white-space: normal !important;" title="<?= esc($detail['tujuan_pembelajaran']); ?>">
    										<?= esc($detail['dimensi']); ?> 
											</th>
                                        <?php endforeach; ?>
                                    <?php endforeach; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $no = 1; foreach ($list_siswa as $siswa) : ?>
                                <tr>
                                    <td style="position: sticky; left: 0; background-color: #fff; z-index: 10;"><?= $no++; ?></td>
                                    <td class="text-left" style="position: sticky; left: 50px; background-color: #fff; z-index: 10;">
                                        <?= esc($siswa['nama_lengkap']); ?>
                                        <input type="hidden" name="siswa_id[]" value="<?= esc($siswa['id']); ?>">
                                    </td>
                                    
                                    <?php foreach ($dimensi_per_tema as $nomor => $details) : ?>
                                        <?php foreach ($details as $detail) : 
                                            $key = $siswa['id'] . '-' . $nomor . '-' . $detail['dimensi'];
                                            $nilai_saat_ini = $nilai_map[$key] ?? '';
                                        ?>
                                            <td>
                                                <select class="form-control form-control-sm" 
                                                        name="nilai[<?= esc($siswa['id']); ?>][<?= esc($nomor); ?>][<?= esc($detail['dimensi']); ?>]" 
                                                        style="width: 70px;">
                                                    <option value="">-</option>
                                                    <option value="1" <?= ($nilai_saat_ini == 1) ? 'selected' : ''; ?>>1 (K)</option>
                                                    <option value="2" <?= ($nilai_saat_ini == 2) ? 'selected' : ''; ?>>2 (C)</option>
                                                    <option value="3" <?= ($nilai_saat_ini == 3) ? 'selected' : ''; ?>>3 (B)</option>
                                                    <option value="4" <?= ($nilai_saat_ini == 4) ? 'selected' : ''; ?>>4 (SB)</option>
                                                </select>
                                            </td>
                                        <?php endforeach; ?>
                                    <?php endforeach; ?>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <button type="submit" class="btn btn-success mt-3">Simpan Nilai</button>
                    <a href="<?= base_url('guru/penilaian_kokurikuler'); ?>" class="btn btn-secondary mt-3">Batal</a>
                </form>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>