    document.addEventListener('DOMContentLoaded', function () {
        const kelasSelect = document.getElementById('kelas_id');
        const mapelSelect = document.getElementById('mapel_id');
        
        const guruMapelData = <?= json_encode($guru_mapel_data); ?>;

        function updateMapelOptions() {
            const selectedKelasId = kelasSelect.value;
            mapelSelect.innerHTML = '<option value="">-- Pilih Mata Pelajaran --</option>';

            const filteredMapels = guruMapelData.filter(item => item.id_kelas == selectedKelasId);
            
            const uniqueMapels = new Set();
            filteredMapels.forEach(item => {
                uniqueMapels.add(JSON.stringify({ id: item.mapel_id, nama_mapel: item.nama_mapel }));
            });

            Array.from(uniqueMapels).map(JSON.parse).sort((a, b) => a.nama_mapel.localeCompare(b.nama_mapel)).forEach(mapel => {
                const option = document.createElement('option');
                option.value = mapel.id;
                option.textContent = mapel.nama_mapel;
                
                if (mapel.id == '<?= esc($selected_mapel_id); ?>') {
                    option.selected = true;
                }
                mapelSelect.appendChild(option);
            });
        }

        if (kelasSelect.value) {
            updateMapelOptions();
        }

        kelasSelect.addEventListener('change', updateMapelOptions);
    });
