<?php

namespace App\Models;

use CodeIgniter\Model;

class FisikAnakModel extends Model
{
    protected $table = 'fisik_anak';
    protected $primaryKey = 'id';
    protected $allowedFields = ['siswa_id', 'berat_badan', 'tinggi_badan', 'semester', 'tahun_ajaran_id'];
    protected $useTimestamps = true;
    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';

    public function getFisikAnakData($tahun_ajaran_id, $semester)
    {
        return $this->select('fisik_anak.*, siswa.nama_lengkap, kelas.nama_kelas')
                    ->join('siswa', 'siswa.id = fisik_anak.siswa_id', 'left')
                    ->join('kelas', 'kelas.id_kelas = siswa.kelas_id', 'left')
                    ->where('fisik_anak.tahun_ajaran_id', $tahun_ajaran_id)
                    ->where('fisik_anak.semester', $semester)
                    ->orderBy('siswa.nama_lengkap', 'ASC')
                    ->findAll();
    }
}