<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('title') ?><?= $title ?><?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="card">
    <!-- Card Header with Title and Tools -->
    <div class="card-header">
        <h3 class="card-title"><?= esc($title) ?></h3>
        <div class="card-tools">
            <!-- The 'Tambah Data' button is moved here -->
            <?php if (empty($daftarSekolah)): ?>
			<a href="<?= base_url('admin/sekolah/new') ?>" class="btn btn-success btn-sm">Tambah Data Sekolah Baru</a>
			<?php endif; ?>
        </div>
    </div>
    
    <!-- Card Body contains the main content -->
    <div class="card-body">
        <?php if (session()->getFlashdata('success')): ?>
            <div class="alert alert-success">
                <?= session()->getFlashdata('success') ?>
            </div>
        <?php endif; ?>
        <?php if (session()->getFlashdata('error')): ?>
            <div class="alert alert-danger">
                <?= session()->getFlashdata('error') ?>
            </div>
        <?php endif; ?>

        <table class="table table-bordered table-hover">
            <thead>
                <tr>
                    <th>No.</th>
                    <th>Nama Sekolah</th>
                    <th>NSS</th>
                    <th>NPSN</th>
                    <th>Alamat</th>
                    <th>Tempat Rapor</th>
                    <th>Tanggal Rapor</th>
                    <th>Kepala Sekolah</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php $no = 1; foreach ($daftarSekolah as $sekolah): ?>
                    <tr>
                        <td><?= $no++ ?></td>
                        <td><?= esc($sekolah['nama_sekolah']) ?></td>
                        <td><?= esc($sekolah['nss']) ?></td>
                        <td><?= esc($sekolah['npsn']) ?></td>
                        <td><?= esc($sekolah['alamat']) ?></td>
                        <td><?= esc($sekolah['tempat_rapor'] ?? '-') ?></td>
                        <td><?= esc($sekolah['tanggal_rapor'] ?? '-') ?></td>
                        <td><?= esc($sekolah['nama_kepala_sekolah'] ?? '-') ?></td>
                        <td>
                            <a href="<?= base_url('admin/sekolah/edit/' . $sekolah['id']) ?>" class="btn btn-primary btn-sm">Edit</a>
                            <a href="<?= base_url('admin/sekolah/delete/' . $sekolah['id']) ?>" class="btn btn-danger btn-sm" onclick="return confirm('Apakah Anda yakin ingin menghapus data sekolah ini?')">Hapus</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <?php if (empty($daftarSekolah)): ?>
                    <tr>
                        <td colspan="9" class="text-center">Tidak ada data sekolah. Silakan tambahkan data baru.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <!-- End Card Body -->
</div>
<!-- End Card -->

<?= $this->endSection() ?>
