<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
//$routes->get('/', 'Home::index');
//$routes->post('guru/kehadiran/getSiswaKehadiran', 'App\Controllers\Guru\Kehadiran::getSiswaKehadiran');
// Routes untuk Otentikasi
$routes->get('/', 'Auth::index'); // Menampilkan halaman login saat mengakses root URL
//$routes->get('auth/login', 'Auth::index'); // Rute opsional untuk kemudahan
$routes->post('login', 'Auth::login');

$routes->get('logout', 'Auth::logout');

// Routes untuk Admin
$routes->group('admin', ['filter' => 'auth:admin'], function ($routes) {
    $routes->get('/', 'admin\dashboardAdmin::index');
    $routes->get('dashboard', 'Admin\DashboardAdmin::index'); // Bisa juga direct ke '/'
    // Tambahkan routes untuk CRUD Sekolah
    $routes->get('sekolah', 'Admin\Sekolah::index');
    $routes->get('sekolah/new', 'Admin\Sekolah::create');
    $routes->post('sekolah/save', 'Admin\Sekolah::store');
    $routes->get('sekolah/edit/(:num)', 'Admin\Sekolah::edit/$1');
    $routes->post('sekolah/update/(:num)', 'Admin\Sekolah::update/$1');
    $routes->get('sekolah/delete/(:num)', 'Admin\Sekolah::delete/$1');

    // Tambahkan routes untuk CRUD Users
    $routes->get('users', 'Admin\User::index');
    $routes->get('users/new', 'Admin\User::create');
    $routes->post('users/save', 'Admin\User::store');
    $routes->get('users/edit/(:num)', 'Admin\User::edit/$1');
    $routes->post('users/update/(:num)', 'Admin\User::update/$1');
    $routes->get('users/delete/(:num)', 'Admin\User::delete/$1');

    // Tambahkan routes untuk CRUD Tahun Ajaran
    $routes->get('tahun_ajaran', 'Admin\TahunAjaran::index');
    $routes->get('tahun_ajaran/new', 'Admin\TahunAjaran::create');
    $routes->post('tahun_ajaran/save', 'Admin\TahunAjaran::save');
	$routes->post('tahun_ajaran/set_active/(:num)', 'Admin\TahunAjaran::set_active/$1');
    $routes->get('tahun_ajaran/edit/(:num)', 'Admin\TahunAjaran::edit/$1');
    $routes->post('tahun_ajaran/update/(:num)', 'Admin\TahunAjaran::update/$1');
    $routes->get('tahun_ajaran/delete/(:num)', 'Admin\TahunAjaran::delete/$1');

    // Tambahkan routes untuk CRUD Mata Pelajaran
    $routes->get('mata_pelajaran', 'Admin\MataPelajaran::index');
    $routes->get('mata_pelajaran/new', 'Admin\MataPelajaran::create');
    $routes->post('mata_pelajaran/save', 'Admin\MataPelajaran::store');
    $routes->get('mata_pelajaran/edit/(:num)', 'Admin\MataPelajaran::edit/$1');
    $routes->post('mata_pelajaran/update/(:num)', 'Admin\MataPelajaran::update/$1');
    $routes->get('mata_pelajaran/delete/(:num)', 'Admin\MataPelajaran::delete/$1');
    
    // Tambahkan routes untuk Manajemen Guru Mata Pelajaran
    $routes->get('guru_mapel', 'Admin\GuruMapel::index');
    $routes->get('guru_mapel/new', 'Admin\GuruMapel::create');
    $routes->post('guru_mapel/save', 'Admin\GuruMapel::store');
    $routes->get('guru_mapel/delete/(:num)', 'Admin\GuruMapel::delete/$1'); // Asumsi delete via GET untuk kesederhanaan awal
    
    // Tambahkan routes untuk CRUD Kelas
    $routes->get('kelas', 'Admin\Kelas::index');
    $routes->get('kelas/new', 'Admin\Kelas::create');
    $routes->post('kelas/save', 'Admin\Kelas::store');
    $routes->get('kelas/edit/(:num)', 'Admin\Kelas::edit/$1');
    $routes->post('kelas/update/(:num)', 'Admin\Kelas::update/$1');
    $routes->get('kelas/delete/(:num)', 'Admin\Kelas::delete/$1');

    // Tambahkan routes untuk CRUD Siswa (oleh Admin)
    $routes->get('siswa', 'Admin\Siswa::index');
    $routes->get('siswa/create', 'Admin\Siswa::create');
    $routes->post('siswa/store', 'Admin\Siswa::store');
    $routes->get('siswa/edit/(:num)', 'Admin\Siswa::edit/$1');
    $routes->post('siswa/update/(:num)', 'Admin\Siswa::update/$1');
    $routes->delete('siswa/delete/(:num)', 'Admin\Siswa::delete/$1');
	
	// Rute untuk Ekstrakurikuler Master
    $routes->get('ekstrakurikuler', 'Admin\Ekstrakurikuler::index');
    $routes->get('ekstrakurikuler/create', 'Admin\Ekstrakurikuler::create');
    $routes->post('ekstrakurikuler/save', 'Admin\Ekstrakurikuler::save');
    $routes->get('ekstrakurikuler/edit/(:num)', 'Admin\Ekstrakurikuler::edit/$1');
    $routes->post('ekstrakurikuler/update/(:num)', 'Admin\Ekstrakurikuler::update/$1');
    $routes->post('ekstrakurikuler/delete/(:num)', 'Admin\Ekstrakurikuler::delete/$1');
	
	// Tambahkan routes untuk CRUD Rentang Nilai (oleh Admin)
    $routes->get('rentang_nilai', 'Admin\RentangNilai::index');
    $routes->post('rentang_nilai/update', 'Admin\RentangNilai::update');
	
	// >>> TAMBAHKAN DUA RUTE INI UNTUK FITUR IMPORT <<<
    $routes->get('siswa/import', 'Admin\Siswa::importView'); // Menampilkan form import
    $routes->post('siswa/import/upload', 'Admin\Siswa::processImport'); // Memproses file import
});

// Routes untuk Guru
$routes->group('guru', ['filter' => 'auth'], function($routes){ // Pastikan filter 'auth' sudah ada dan berfungsi
    $routes->get('dashboard', 'Guru\DashboardGuru::index');
    

    // Siswa (Guru)
    $routes->get('siswa', 'Guru\Siswa::index');

    // Routes untuk Manajemen Profil Guru
    $routes->get('profile', 'Guru\\Profile::index'); // Menggantikan change_password
    $routes->post('profile/update', 'Guru\\Profile::update'); // Menggantikan update_password

    // TP Mapel (Guru)
    $routes->get('tp_mapel', 'Guru\TpMapel::index');
	$routes->get('tp_mapel/create', 'Guru\TpMapel::create');
    $routes->post('tp_mapel/store', 'Guru\TpMapel::store');
	$routes->get('tp_mapel/edit/(:num)', 'Guru\TpMapel::edit/$1');
    $routes->put('tp_mapel/update/(:num)', 'Guru\TpMapel::update/$1'); // Menggunakan POST karena form
    $routes->get('tp_mapel/delete/(:num)', 'Guru\TpMapel::delete/$1');

    // Rute untuk Manajemen Penilaian
    $routes->get('penilaian', 'Guru\Penilaian::index');
    $routes->post('penilaian/index', 'Guru\Penilaian::index');
	$routes->post('penilaian/process', 'Guru\Penilaian::process'); // Menggunakan 'process' untuk handle pemilihan mapel/kelas DAN penyimpanan nilai
    $routes->get('penilaian/nilaiAkhirRapor', 'Guru\Penilaian::nilaiAkhirRapor');
	$routes->post('penilaian/finalisasi', 'Guru\Penilaian::finalisasiNilai');
	$routes->get('penilaian/hitungNilaiAkhir', 'Guru\Penilaian::hitungNilaiAkhir');
	$routes->get('penilaian/deskripsi', 'Guru\Penilaian::deskripsi');
    $routes->post('penilaian/deskripsi', 'Guru\Penilaian::deskripsi');
	// Jika Anda ingin metode edit/delete spesifik
    // $routes->get('penilaian/edit/(:num)', 'Guru\Penilaian::edit/$1');
    // $routes->post('penilaian/update/(:num)', 'Guru\Penilaian::update/$1');
    // $routes->get('penilaian/delete/(:num)', 'Guru\Penilaian::delete/$1');
    
    // Nilai Asesmen Mapel (Guru)
    $routes->get('nilai_asesmen_mapel', 'Guru\NilaiAsesmenMapel::index');
    $routes->post('nilai_asesmen_mapel/save', 'Guru\NilaiAsesmenMapel::store');
    $routes->get('nilai_asesmen_mapel/edit/(:num)', 'Guru\NilaiAsesmenMapel::edit/$1');
    $routes->post('nilai_asesmen_mapel/update/(:num)', 'Guru\NilaiAsesmenMapel::update/$1');

    // Deskripsi Mapel (Guru)
    $routes->get('deskripsi_mapel', 'Guru\DeskripsiMapel::index');
    $routes->post('deskripsi_mapel/save', 'Guru\DeskripsiMapel::store');

    // Proyek P5 (Guru)
    $routes->get('proyek_p5', 'Guru\ProyekP5::index');
    $routes->get('proyek_p5/new', 'Guru\ProyekP5::create');
    $routes->post('proyek_p5/save', 'Guru\ProyekP5::store');
    $routes->get('proyek_p5/edit/(:num)', 'Guru\ProyekP5::edit/$1');
    $routes->post('proyek_p5/update/(:num)', 'Guru\ProyekP5::update/$1');
    $routes->get('proyek_p5/delete/(:num)', 'Guru\ProyekP5::delete/$1');

    // Penilaian P5 (Guru)
    $routes->get('penilaian_p5', 'Guru\PenilaianP5::index');
    $routes->post('penilaian_p5/save', 'Guru\PenilaianP5::store');
    $routes->get('penilaian_p5/edit/(:num)', 'Guru\PenilaianP5::edit/$1');
    $routes->post('penilaian_p5/update/(:num)', 'Guru\PenilaianP5::update/$1');

    // Kehadiran (Guru)
    //$routes->get('kehadiran', 'Guru\Kehadiran::index');
    $routes->get('kehadiran', 'Guru\Kehadiran::index');
    $routes->post('kehadiran/process', 'Guru\Kehadiran::process');
	$routes->post('kehadiran/index', 'Guru\\Kehadiran::index');
	$routes->post('kehadiran/save', 'Guru\\Kehadiran::save');
    //$routes->post('kehadiran', 'Guru\Kehadiran::store'); // Menggunakan POST ke URL yang sama
    //$routes->post('kehadiran/getSiswaKehadiran', 'Guru\Kehadiran::getSiswaKehadiran');

    // Ekstrakurikuler (Guru)
    $routes->get('ekskul_wali_kelas', 'Guru\EkskulWaliKelas::index');
    $routes->post('ekskul_wali_kelas', 'Guru\EkskulWaliKelas::index');
    $routes->get('ekskul_wali_kelas/add', 'Guru\EkskulWaliKelas::add');
    $routes->get('ekskul_wali_kelas/delete/(:num)', 'Guru\EkskulWaliKelas::delete/$1');
    $routes->get('ekskul_wali_kelas/create', 'Guru\EkskulWaliKelas::create');
    $routes->post('ekskul_wali_kelas/save', 'Guru\EkskulWaliKelas::save');
    $routes->post('ekskul_wali_kelas/save_add', 'Guru\EkskulWaliKelas::save_add');

    // Routes baru untuk Fisik Anak
    $routes->get('fisik_anak', 'Guru\FisikAnak::index');
    $routes->get('fisik_anak/create', 'Guru\FisikAnak::create');
    $routes->post('fisik_anak/store', 'Guru\FisikAnak::store');
    $routes->get('fisik_anak/edit/(:num)', 'Guru\FisikAnak::edit/$1');
    $routes->post('fisik_anak/update/(:num)', 'Guru\FisikAnak::update/$1');
    $routes->get('fisik_anak/delete/(:num)', 'Guru\FisikAnak::delete/$1');

    // Kokurikuler (Guru)
	$routes->get('kokurikuler', 'Guru\KokurikulerController::index');
    $routes->get('kokurikuler/create', 'Guru\KokurikulerController::create');
    $routes->post('kokurikuler/save', 'Guru\KokurikulerController::save'); 
    $routes->get('kokurikuler/edit/(:num)', 'Guru\KokurikulerController::edit/$1');
    $routes->put('kokurikuler/update/(:num)', 'Guru\KokurikulerController::update/$1'); 
    $routes->post('kokurikuler/delete/(:num)', 'Guru\KokurikulerController::delete/$1');
	$routes->delete('kokurikuler/delete/(:num)', 'Guru\\KokurikulerController::delete/$1');
	
	// Penilaian Kokurikuler ---
    $routes->get('penilaian_kokurikuler', 'Guru\\PenilaianKokurikulerController::index');
    $routes->get('penilaian_kokurikuler/input/(:num)', 'Guru\\PenilaianKokurikulerController::input/$1');
    $routes->post('penilaian_kokurikuler/store', 'Guru\\PenilaianKokurikulerController::store');
	
	// Deskripsi Kokurikuler
	$routes->get('penilaian_kokurikuler/deskripsi', 'Guru\\PenilaianKokurikulerController::deskripsi');
	$routes->post('penilaian_kokurikuler/generate_deskripsi', 'Guru\\PenilaianKokurikulerController::generateDeskripsi');
	
	// Catatan Wali Kelas (Guru)
    $routes->get('catatan_wali_kelas', 'Guru\CatatanWaliKelas::index');
    $routes->post('catatan_wali_kelas', 'Guru\CatatanWaliKelas::index');
    $routes->post('catatan_wali_kelas/save', 'Guru\CatatanWaliKelas::save');

	// Rute untuk fitur naik kelas bertahap (di bawah grup 'guru')
	$routes->get('siswa/naikKelas', 'Guru\Siswa::naikKelas');
    $routes->post('siswa/setKenaikanRapor', 'Guru\Siswa::setKenaikanRapor');
    $routes->post('siswa/prosesPindahKelas', 'Guru\Siswa::prosesPindahKelas');
	$routes->get('siswa/koreksiKenaikanKelas/(:num)/(:num)', 'Guru\Siswa::koreksiKenaikanKelas/$1/$2');
	//$routes->post('siswa/updateStatusKenaikan', 'Guru\Siswa::updateStatusKenaikan');
	$routes->post('siswa/saveKoreksiStatusBatch', 'Guru\Siswa::saveKoreksiStatusBatch');
	
	// Rute untuk Rapor Cover
    $routes->get('rapor_cover', 'Guru\RaporCover::index');
    $routes->post('rapor_cover', 'Guru\RaporCover::index');
    $routes->post('rapor_cover/save', 'Guru\RaporCover::save');
    $routes->post('rapor_cover/generate_pdf', 'Guru\RaporCover::generate_pdf');
	$routes->get('rapor_cover/preview/(:num)/(:num)', 'Guru\RaporCover::preview/$1/$2');

    // Rapor (Guru)
    $routes->get('nilai_rapor', 'Guru\NilaiRapor::index');
    $routes->get('nilai_rapor/create', 'Guru\NilaiRapor::create');
    $routes->post('nilai_rapor/store', 'Guru\NilaiRapor::store');
    
    // Rapor Siswa cetak (Guru)
    $routes->get('rapor', 'Guru\Rapor::index');
    $routes->post('rapor/pratinjau', 'Guru\Rapor::pratinjauRapor');
    $routes->post('rapor/cetak', 'Guru\Rapor::cetakRapor');
    $routes->post('rapor/cetakLeger', 'Guru\Rapor::cetakLeger');
    $routes->post('rapor/cetakPengambilanRapor', 'Guru\Rapor::cetakPengambilanRapor');

});

// Routes untuk Kepala Sekolah
$routes->group('kepsek', ['filter' => 'auth:kepala_sekolah'], function ($routes) {
    $routes->get('/', 'KepalaSekolah\DashboardKepsek::index');
    $routes->get('dashboard', 'KepalaSekolah\DashboardKepsek::index');

    // Rapor (Kepsek)
    $routes->get('rapor', 'KepalaSekolah\RaporKepsek::index');
    $routes->get('rapor/view/(:num)', 'KepalaSekolah\RaporKepsek::view/$1');
    $routes->post('rapor/verifikasi/(:num)', 'KepalaSekolah\RaporKepsek::verifikasi/$1'); // Untuk verifikasi

    // Laporan (Kepsek)
    $routes->get('laporan', 'KepalaSekolah\Laporan::index');
    $routes->get('laporan/rekap_nilai', 'KepalaSekolah\Laporan::rekapNilai');
});