<?= $this->extend('layout/guru_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('success'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                <?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('error'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <?php if (!empty($message)) : ?>
                    <div class="alert alert-danger">
                        <?= esc($message) ?>
                    </div>
                <?php elseif (empty($siswa)) : ?>
                    <div class="alert alert-info">Anda bukan wali kelas atau tidak ada siswa ditemukan di kelas Anda.</div>
                <?php else : ?>
                    <form action="<?= base_url('guru/kehadiran/save'); ?>" method="post">
                        <?= csrf_field(); ?>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>No.</th>
                                        <th>NIS</th>
                                        <th>Nama Siswa</th>
                                        <th>Kelas</th>
                                        <th>Sakit</th>
                                        <th>Izin</th>
                                        <th>Tanpa Keterangan</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $no = 1; ?>
                                    <?php foreach ($siswa as $s) : ?>
                                        <tr>
                                            <td><?= $no++; ?></td>
                                            <td><?= esc($s['nis']); ?></td>
                                            <td><?= esc($s['nama_lengkap']); ?></td>
                                            <td><?= esc($s['nama_kelas']); ?></td>
                                            <td>
                                                <input type="number" class="form-control" name="sakit[<?= esc($s['id']); ?>]" value="<?= isset($data_kehadiran[$s['id']]['sakit']) ? esc($data_kehadiran[$s['id']]['sakit']) : 0; ?>">
                                            </td>
                                            <td>
                                                <input type="number" class="form-control" name="izin[<?= esc($s['id']); ?>]" value="<?= isset($data_kehadiran[$s['id']]['izin']) ? esc($data_kehadiran[$s['id']]['izin']) : 0; ?>">
                                            </td>
                                            <td>
                                                <input type="number" class="form-control" name="tanpa_keterangan[<?= esc($s['id']); ?>]" value="<?= isset($data_kehadiran[$s['id']]['tanpa_keterangan']) ? esc($data_kehadiran[$s['id']]['tanpa_keterangan']) : 0; ?>">
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <button type="submit" class="btn btn-primary mt-3">Simpan Rekap Kehadiran</button>
                    </form>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>