<?php

namespace App\Models;

use CodeIgniter\Model;

class DeskripsiMapelRaporModel extends Model
{
    protected $table            = 'deskripsi_mapel_rapor';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['siswa_id', 'mapel_id', 'semester', 'tahun_ajaran_id', 'deskripsi_tp_tercapai', 'deskripsi_tp_perlu_bimbingan'];

    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules = [
        'siswa_id'          => 'required|is_natural_no_zero',
        'mapel_id'          => 'required|is_natural_no_zero',
        'semester'          => 'required|in_list[1,2]',
        'tahun_ajaran_id'   => 'required|is_natural_no_zero',
    ];
    protected $validationMessages = [];
    protected $skipValidation = false;
}