<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('content') ?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title"><?= esc($title) ?></h3>
    </div>
    <div class="card-body">
        <form action="<?= base_url('admin/tahun_ajaran/save') ?>" method="post">
            <?= csrf_field() ?>

            <div class="form-group">
                <label for="nama_tahun">Tahun Ajaran:</label>
                <input type="text" name="nama_tahun" id="nama_tahun" class="form-control <?= (session('errors.nama_tahun')) ? 'is-invalid' : ''; ?>" value="<?= old('nama_tahun') ?>">
                <?php if(session('errors.nama_tahun')): ?>
                    <div class="invalid-feedback">
                        <?= session('errors.nama_tahun') ?>
                    </div>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="semester">Semester:</label>
                <select name="semester" id="semester" class="form-control <?= (session('errors.semester')) ? 'is-invalid' : ''; ?>">
                    <option value="">Pilih Semester</option>
                    <?php foreach ($semester_options as $option): ?>
                        <option value="<?= $option ?>" <?= (old('semester') == $option) ? 'selected' : ''; ?>>
                            <?= $option ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <?php if(session('errors.semester')): ?>
                    <div class="invalid-feedback">
                        <?= session('errors.semester') ?>
                    </div>
                <?php endif; ?>
            </div>
            
            <button type="submit" class="btn btn-primary">Simpan</button>
            <a href="<?= base_url('admin/tahun_ajaran') ?>" class="btn btn-secondary">Batal</a>
        </form>
    </div>
</div>

<?= $this->endSection() ?>
