<?= $this->extend('layout/guru_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('success'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                <?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('error'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <?php if (!empty($message)) : ?>
                    <div class="alert alert-danger">
                        <?= esc($message) ?>
                    </div>
                <?php else: ?>
                    <a href="<?= base_url('guru/ekskul_wali_kelas/add'); ?>" class="btn btn-success mb-3">Tambah Ekstrakurikuler</a>
                    <hr>
                    <form action="<?= base_url('guru/ekskul_wali_kelas/save') ?>" method="post">
                        <?= csrf_field() ?>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>No.</th>
                                        <th>Nama Siswa</th>
                                        <th>Kelas</th>
                                        <th>Ekskul</th>
                                        <th>Deskripsi</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $no = 1; ?>
                                    <?php foreach ($siswa_ekskul as $ekskul) : ?>
                                        <tr>
                                            <td><?= $no++; ?></td>
                                            <td>
                                                <?= esc($ekskul['nama_lengkap']); ?>
                                                <input type="hidden" name="ekskul_data[<?= $ekskul['id']; ?>][id]" value="<?= esc($ekskul['id']); ?>">
                                            </td>
                                            <td><?= esc($ekskul['nama_kelas']); ?></td>
                                            <td><?= esc($ekskul['nama_ekskul']); ?></td>
                                            <td>
                                                <textarea name="ekskul_data[<?= $ekskul['id']; ?>][deskripsi_ekskul]" class="form-control" rows="3"><?= esc($ekskul['deskripsi_ekskul']); ?></textarea>
                                            </td>
                                            <td>
                                                <a href="<?= base_url('guru/ekskul_wali_kelas/delete/' . $ekskul['id']); ?>" class="btn btn-danger btn-sm" onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?')">Hapus</a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <button type="submit" class="btn btn-primary mt-3">Simpan Perubahan</button>
                    </form>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>