<?= $this->extend('layout/guru_layout'); ?>
<?php // Asumsi template admin/layout/template digunakan juga untuk guru ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div><div class="card-body">
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('success'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                <?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('error'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                <?php if (session()->getFlashdata('error_message')) : ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('error_message'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <form action="<?= base_url('guru/profile/update'); ?>" method="post">
                    <?= csrf_field(); ?>

                    <h4>Data Profil</h4>
                    <div class="form-group">
                        <label for="nama">Nama Lengkap</label>
                        <input type="text" name="nama" id="nama" class="form-control <?= ($validation->hasError('nama')) ? 'is-invalid' : ''; ?>" value="<?= old('nama', $user_data['nama']); ?>" required>
                        <?php if ($validation->hasError('nama')) : ?>
                            <div class="invalid-feedback">
                                <?= $validation->getError('nama'); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="nip">NIP</label>
                        <input type="text" name="nip" id="nip" class="form-control <?= ($validation->hasError('nip')) ? 'is-invalid' : ''; ?>" value="<?= old('nip', $user_data['nip'] ?? ''); ?>" required>
                        <?php if ($validation->hasError('nip')) : ?>
                            <div class="invalid-feedback">
                                <?= $validation->getError('nip'); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="username">Username</label>
                        <input type="text" name="username" id="username" class="form-control <?= ($validation->hasError('username')) ? 'is-invalid' : ''; ?>" value="<?= old('username', $user_data['username'] ?? ''); ?>" required>
                        <?php if ($validation->hasError('username')) : ?>
                            <div class="invalid-feedback">
                                <?= $validation->getError('username'); ?>
                            </div>
                        <?php endif; ?>
                    </div>

                    <h4 class="mt-4">Ganti Password (isi hanya jika ingin mengubah password)</h4>
                    <div class="form-group">
                        <label for="old_password">Password Lama</label>
                        <input type="password" name="old_password" id="old_password" class="form-control <?= ($validation->hasError('old_password')) ? 'is-invalid' : ''; ?>">
                        <?php if ($validation->hasError('old_password')) : ?>
                            <div class="invalid-feedback">
                                <?= $validation->getError('old_password'); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="new_password">Password Baru</label>
                        <input type="password" name="new_password" id="new_password" class="form-control <?= ($validation->hasError('new_password')) ? 'is-invalid' : ''; ?>">
                        <?php if ($validation->hasError('new_password')) : ?>
                            <div class="invalid-feedback">
                                <?= $validation->getError('new_password'); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="confirm_password">Konfirmasi Password Baru</label>
                        <input type="password" name="confirm_password" id="confirm_password" class="form-control <?= ($validation->hasError('confirm_password')) ? 'is-invalid' : ''; ?>">
                        <?php if ($validation->hasError('confirm_password')) : ?>
                            <div class="invalid-feedback">
                                <?= $validation->getError('confirm_password'); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                    <a href="<?= base_url('guru/dashboard'); ?>" class="btn btn-secondary ml-2">Batal</a>
                </form>
            </div></div></div></div><?= $this->endSection(); ?>