<!DOCTYPE html>
<html>
<head>
    <title>Cover Rapor - <?= esc($siswa['nama_lengkap']); ?></title>
    <style>
        <?= $style_css; ?>
        /* CSS tambahan untuk meratakan teks secara vertikal */
        .info-table td {
            vertical-align: middle;
        }
        /* Jika menggunakan page-break, pastikan tidak ada tinggi default */
        .page-break {
            height: auto; 
            border: none;
        }
        /* Gaya untuk kotak foto */
        .photo-box {
            width: 90px;
            height: 120px;
            border: 1px solid #000;
            margin: auto;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 10px;
            text-align: center;
        }
		
		<?php if (isset($is_preview) && $is_preview): ?>
        /* ==================================================== */
        /* CSS KHUSUS IFRAME: MENSIMULASIKAN KERTAS A4 */
        /* ==================================================== */

        /* A. Batasi Halaman ke Ukuran A4 Fisik */
        .page {
            width: 210mm; /* Kunci: Batasi lebar ke A4 */
            min-height: 297mm;
            margin: 10mm auto; /* Tengahkan halaman */
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
            background-color: white; 
            box-sizing: border-box; 
        }

        /* B. Perbaiki Tulisan Kementerian (Overlap) */
        /* Ini adalah perbaikan asumsi untuk elemen yang menggunakan absolute positioning */
        .page-1 .bottom-section {
            /* Gunakan positioning relatif dan dorongan margin */
            position: relative !important; 
            margin-top: 100px; /* Nilai ini mungkin perlu disesuaikan sedikit */
        }
        
        /* Tambahan: Tambahkan margin besar di elemen tepat di atas bottom-section jika diperlukan */
        .page-1 .student-info-table {
            margin-bottom: 50px !important;
        }

        <?php endif; ?>
        
		.ttd-section {
            width: 100%;
        }
    </style>
</head>
<body>
    <div class="page page-1">
        <div class="text-center top-section">
            <?php if ($logo_base64): ?>
                <img src="<?= $logo_base64; ?>" alt="Logo Sekolah" class="logo">
            <?php endif; ?>
            <p class="motto">TUT WURI HANDAYANI</p>
            <h1 class="title-main">RAPOR PESERTA DIDIK</h1>
            <h2 class="title-sub"><strong><?= esc($sekolah['nama_sekolah']); ?></strong></h2>
        </div>
        
        <div class="student-info-section">
            <table class="student-info-table">
                <tr>
                    <td class="label">Nama Peserta Didik</td>
                </tr>
                <tr>
                    <td class="value student-name"><?= esc($siswa['nama_lengkap']); ?></td>
                </tr>
                <tr>
                    <td class="label">NISN/NIS</td>
                </tr>
                <tr>
                    <td class="value student-nis"><?= esc($siswa['nisn']); ?> / <?= esc($siswa['nis']); ?></td>
                </tr>
            </table>
        </div>
    <div style="margin-top: 150px;"></div> 
	<div class="text-center bottom-section">
    <strong>
        <p style="margin-bottom: 0;">KEMENTERIAN PENDIDIKAN, KEBUDAYAAN, RISET, DAN TEKNOLOGI</p>
        <p style="margin-top: 0;">REPUBLIK INDONESIA</p>
    </strong>
	</div>
    </div>
    
    <div class="page page-break page-2">
        <div class="text-center top-section">
            <h1 class="rapor-title">RAPOR PESERTA DIDIK</h1>
            <h2 class="rapor-subtitle">SEKOLAH DASAR</h2>
            <h2 class="rapor-subtitle">(SD)</h2>
        </div>
        
        <div class="school-info-section">
            <table class="info-table">
                <tr>
                    <td class="label">Nama Sekolah</td>
                    <td class="separator">:</td>
                    <td class="value"><?= esc($sekolah['nama_sekolah'] ?? ''); ?></td>
                </tr>
                <tr>
                    <td class="label">NPSN</td>
                    <td class="separator">:</td>
                    <td class="value"><?= esc($sekolah['npsn'] ?? ''); ?></td>
                </tr>
                <tr>
                    <td class="label">Alamat Sekolah</td>
                    <td class="separator">:</td>
                    <td class="value"><?= esc($sekolah['alamat'] ?? ''); ?></td>
                </tr>
                <tr>
                    <td class="label">Kode Pos</td>
                    <td class="separator">:</td>
                    <td class="value"><?= esc($sekolah['kode_pos'] ?? ''); ?></td>
                </tr>
                <tr>
                    <td class="label">Telp.</td>
                    <td class="separator">:</td>
                    <td class="value"><?= esc($sekolah['telp'] ?? ''); ?></td>
                </tr>
                <tr>
                    <td class="label">Kelurahan/Desa</td>
                    <td class="separator">:</td>
                    <td class="value"><?= esc($sekolah['kelurahan_desa'] ?? ''); ?></td>
                </tr>
                <tr>
                    <td class="label">Kapanewon</td>
                    <td class="separator">:</td>
                    <td class="value"><?= esc($sekolah['kapanewon'] ?? ''); ?></td>
                </tr>
                <tr>
                    <td class="label">Kabupaten/Kota</td>
                    <td class="separator">:</td>
                    <td class="value"><?= esc($sekolah['kabupaten_kota'] ?? ''); ?></td>
                </tr>
                <tr>
                    <td class="label">Provinsi</td>
                    <td class="separator">:</td>
                    <td class="value"><?= esc($sekolah['provinsi'] ?? ''); ?></td>
                </tr>
                <tr>
                    <td class="label">Website</td>
                    <td class="separator">:</td>
                    <td class="value"><?= esc($sekolah['website'] ?? ''); ?></td>
                </tr>
                <tr>
                    <td class="label">Email</td>
                    <td class="separator">:</td>
                    <td class="value"><?= esc($sekolah['email'] ?? ''); ?></td>
                </tr>
            </table>
        </div>

    </div>

    <div class="page page-break page-3">
        <div class="text-center top-section">
            <h1 class="title-main">PETUNJUK PENGISIAN</h1>
        </div>
        <h2 > </h2>
		<div class="instruction-content">
          <ol style="text-align: justify;">
            <li>Laporan Rapor Peserta Didik dipergunakan selama peserta didik yang bersangkutan mengikuti seluruh program pembelajaran di Sekolah Dasar tersebut.</li>
            <li>Identitas Sekolah diisi dengan data yang sesuai dengan keberadaan Sekolah Dasar.</li>
            <li>Daftar peserta didik diisi oleh data siswa yang ada dalam Rapor Peserta Didik ini.</li>
            <li>Identitas peserta didik diisi sesuai dengan dokumen pendukung peserta didik.</li>
            <li>Rapor peserta didik harus dilengkapi dengan pas foto berwarna (3x4) dan pengisiannya dilakukan oleh Guru Kelas.</li>
            <li>Nilai rapor diperoleh dari pengolahan nilai hasil Asesmen Sumatif Lingkup Materi, dan Asesmen Sumatif Akhir Semester dengan pembobotan tertentu yang ditentukan oleh sekolah.</li>
            <li>Deskripsi merupakan uraian capaian kompetensi tertinggi dan terendah yang dicapai berdasarkan hasil data asesmen Formatif yang dikonfirmasi dengan hasil data asesmen sumatif.</li>
            <li>Laporan ekstrakurikuler diisi dengan kegiatan ekstrakurikuler yang diikuti oleh peserta didik.</li>
            <li>Kolom ketidakhadiran ditulis dengan data akumulasi ketidakhadiran peserta didik karena sakit, izin, atau tanpa keterangan selama satu semester.</li>
            <li>Apabila peserta didik pindah, maka dicatat di dalam kolom keterangan pindah.</li>
            <li>Kolom pernyataan kenaikan kelas diisi keterangan naik atau tinggal kelas.</li>
          </ol>
        </div>
    </div>

    <div class="page page-break page-4">
        <div class="text-center top-section">
            <h1 class="title-main">IDENTITAS PESERTA DIDIK</h1>
        </div>
        <h2 > </h2>
        <div class="student-detail-section">
            <table class="info-table student-detail-table">
                <tr>
                    <td class="label-col-no">1.</td>
                    <td class="label-col">Nama Peserta Didik</td>
                    <td class="separator">:</td>
                    <td class="value-col"><?= esc($siswa['nama_lengkap']); ?></td>
                </tr>
                <tr>
                    <td class="label-col-no">2.</td>
                    <td class="label-col">NISN/NIS</td>
                    <td class="separator">:</td>
                    <td class="value-col"><?= esc($siswa['nisn']); ?> / <?= esc($siswa['nis']); ?></td>
                </tr>
                <tr>
                    <td class="label-col-no">3.</td>
                    <td class="label-col">Tempat, Tgl Lahir</td>
                    <td class="separator">:</td>
                    <td class="value-col"><?= esc($siswa['tempat_lahir'] . ', ' . (tanggal_indonesia(date('d F Y', strtotime($siswa['tanggal_lahir'] ?? date('Y-m-d')))))); ?></td>
               	</tr>
                <tr>
                    <td class="label-col-no">4.</td>
                    <td class="label-col">Jenis Kelamin</td>
                    <td class="separator">:</td>
                    <td class="value-col"><?= esc($siswa['jenis_kelamin']); ?></td>
                </tr>
                <tr>
                    <td class="label-col-no">5.</td>
                    <td class="label-col">Agama</td>
                    <td class="separator">:</td>
                    <td class="value-col"><?= esc($siswa['agama']); ?></td>
                </tr>
                <tr>
                    <td class="label-col-no">6.</td>
                    <td class="label-col">Pendidikan Sebelumnya</td>
                    <td class="separator">:</td>
                    <td class="value-col"><?= esc($siswa['pendidikan_sebelumnya'] ?? ''); ?></td>
                </tr>
                <tr>
                    <td class="label-col-no">7.</td>
                    <td class="label-col">Alamat Peserta Didik</td>
                    <td class="separator">:</td>
                    <td class="value-col"><?= esc($siswa['alamat']); ?></td>
                </tr>
                <tr>
                    <td class="label-col-no">8.</td>
                    <td class="label-col">Nama Orang Tua</td>
                    <td class="separator"></td>
                    <td class="value-col"></td>
                </tr>
                <tr>
                    <td class="label-col-no"></td>
                    <td class="label-col-sub">a. Ayah</td>
                    <td class="separator">:</td>
                    <td class="value-col"><?= esc($siswa['nama_ayah'] ?? ''); ?></td>
                </tr>
                <tr>
                    <td class="label-col-no"></td>
                    <td class="label-col-sub">b. Ibu</td>
                    <td class="separator">:</td>
                    <td class="value-col"><?= esc($siswa['nama_ibu'] ?? ''); ?></td>
                </tr>
                <tr>
                    <td class="label-col-no">9.</td>
                    <td class="label-col">Pekerjaan Orang Tua</td>
                    <td class="separator"></td>
                    <td class="value-col"></td>
                </tr>
                <tr>
                    <td class="label-col-no"></td>
                    <td class="label-col-sub">a. Ayah</td>
                    <td class="separator">:</td>
                    <td class="value-col"><?= esc($siswa['pekerjaan_ayah'] ?? ''); ?></td>
                </tr>
                <tr>
                    <td class="label-col-no"></td>
                    <td class="label-col-sub">b. Ibu</td>
                    <td class="separator">:</td>
                    <td class="value-col"><?= esc($siswa['pekerjaan_ibu'] ?? ''); ?></td>
                </tr>
                <tr>
                    <td class="label-col-no">10.</td>
                    <td class="label-col">Alamat Orang Tua</td>
                    <td class="separator">:</td>
                    <td class="value-col"><?= esc($siswa['alamat']); ?></td>
                </tr>
				<tr>
                    <td class="label-col-no">11.</td>
                    <td class="label-col">Wali Peserta Didik</td>
                    <td class="separator"></td>
                    <td class="value-col"></td>
                </tr>
                <tr>
                    <td class="label-col-no"></td>
                    <td class="label-col-sub">a. Nama</td>
                    <td class="separator">:</td>
                    <td class="value-col"><?= esc($siswa['nama_wali'] ?? ''); ?></td>
                </tr>
                <tr>
                    <td class="label-col-no"></td>
                    <td class="label-col-sub">b. Pekerjaan</td>
                    <td class="separator">:</td>
                    <td class="value-col"><?= esc($siswa['pekerjaan_wali'] ?? ''); ?></td>
				</tr>
				<tr>
                    <td class="label-col-no"></td>
                    <td class="label-col-sub">c. Alamat</td>
                    <td class="separator">:</td>
                    <td class="value-col"><?= esc($siswa['alamat_wali'] ?? ''); ?></td>
				</tr>
            </table>
        </div>
        
        <table class="ttd-section">
            <tr>
                <td style="width: 40%;"><div class="photo-box">Pas Foto 3x4</div></td>
                <td style="width: 20%;"></td>
                <td style="width: 40%; text-align: center;">
                    <?= esc($sekolah['tempat_rapor'] ?? ''); ?>, 
                    <?= esc(tanggal_indonesia(date('d F Y', strtotime($sekolah['tanggal_rapor'] ?? date('Y-m-d'))))); ?>
                    <br>Kepala Sekolah
                    <div style="height: 60px;"></div>
                    <u><?= esc($kepala_sekolah['nama'] ?? ''); ?></u>
                    <br>NIP. <?= esc($kepala_sekolah['nip'] ?? '-'); ?>
                </td>
            </tr>
        </table>
    </div>
</body>
</html>
