<?php

namespace App\Controllers;

use App\Models\UserModel; // Import UserModel
use CodeIgniter\Controller;

class Auth extends BaseController
{
    public function index()
    {
        // Cek apakah user sudah login, jika ya, arahkan ke dashboard yang sesuai
        $session = session();
        if ($session->get('logged_in')) {
            $role = $session->get('role');
            switch ($role) {
                case 'admin':
                    return redirect()->to(base_url('admin/dashboard'));
                case 'guru':
                    return redirect()->to(base_url('guru/dashboard'));
                case 'kepala_sekolah':
                    return redirect()->to(base_url('kepsek/dashboard'));
                default:
                    return redirect()->to(base_url('/')); // Default ke login jika peran tidak dikenali
            }
        }

        // Tampilkan halaman login
        return view('auth/login');
    }

    public function login()
    {
        $session = session();
        $userModel = new UserModel();
        $request = service('request');

        // Validasi input
        $rules = [
            'username' => 'required|min_length[3]',
            'password' => 'required|min_length[6]',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('error', 'Username dan password harus diisi dengan benar.');
        }

        $username = $request->getVar('username');
        $password = $request->getVar('password');

        // Cari user berdasarkan username
        $user = $userModel->where('username', $username)->first();

        if ($user) {
            // Verifikasi password
            if (password_verify($password, $user['password'])) {
                // Password cocok, buat sesi
                $ses_data = [
                    'logged_in'  => TRUE,
                    'user_id'    => $user['id'],
                    'username'   => $user['username'],
                    'role'       => $user['role'],
                    'nama'       => $user['nama'], // Tambahkan nama untuk tampilan
                    'nip'        => $user['nip'],  // Tambahkan NIP
                    'logged_in'  => TRUE
                ];
                $session->set($ses_data);
				
				// --- Mulai Debugging di Auth Controller ---
                // echo "ID dari user array: " . $user['id'] . "<br>";
                // echo "ID yang disimpan ke sesi: " . $session->get('id') . "<br>";
                // echo "Semua data sesi:<br>";
                // dd($session->get()); // Ini akan menampilkan seluruh isi sesi dan menghentikan eksekusi
                // --- Akhir Debugging ---

                // Redirect ke dashboard sesuai peran
                switch ($user['role']) {
                    case 'admin':
                        return redirect()->to(base_url('admin/dashboard'))->with('success', 'Selamat datang, Admin ' . $user['nama'] . '!');
                    case 'guru':
                        return redirect()->to(base_url('guru/dashboard'))->with('success', 'Selamat datang, Bapak/Ibu Guru ' . $user['nama'] . '!');
                    case 'kepala_sekolah':
                        return redirect()->to(base_url('kepsek/dashboard'))->with('success', 'Selamat datang, Kepala Sekolah ' . $user['nama'] . '!');
                    default:
                        return redirect()->to(base_url('/'))->with('error', 'Peran pengguna tidak valid.');
                }

            } else {
                // Password tidak cocok
                $session->setFlashdata('error', 'Password salah.');
                return redirect()->back()->withInput();
            }
        } else {
            // User tidak ditemukan
            $session->setFlashdata('error', 'Username tidak ditemukan.');
            return redirect()->back()->withInput();
        }
    }

    public function logout()
    {
        $session = session();
        $session->destroy(); // Hapus semua data sesi
        return redirect()->to(base_url('/'))->with('success', 'Anda telah berhasil logout.');
    }
}