<?php

namespace App\Models;

use CodeIgniter\Model;

class SiswaModel extends Model
{
    protected $table            = 'siswa';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'nisn', 'nis', 'pendidikan_sebelumnya', 'nama_lengkap', 'nama_panggilan', 'jenis_kelamin', 'agama', 'kelas_id',
        'tempat_lahir', 'tanggal_lahir', 'alamat', 'kelurahan_desa',
        'kapanewon', 'kabupaten_kota', 'provinsi', 'nama_ayah',
        'pekerjaan_ayah', 'nama_ibu', 'pekerjaan_ibu', 'nama_wali',
        'pekerjaan_wali', 'alamat_wali' // <-- KOLOM BARU DITAMBAHKAN DI SINI
    ];

    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules = [
        'nisn'                  => 'permit_empty|exact_length[10]|numeric|is_unique[siswa.nisn,id,{id}]',
        'nis'                   => 'permit_empty|max_length[10]|numeric|is_unique[siswa.nis,id,{id}]',
        'nama_lengkap'          => 'required|min_length[3]',
        'nama_panggilan'        => 'required|min_length[3]',
		'jenis_kelamin'         => 'permit_empty|min_length[3]',
		'agama'                 => 'permit_empty|min_length[3]',
		'kelas_id'              => 'required|is_natural_no_zero',
        'tempat_lahir'          => 'permit_empty|min_length[3]',
        'tanggal_lahir'         => 'permit_empty|valid_date',
        'alamat'                => 'permit_empty|min_length[5]',
        'kelurahan_desa'        => 'permit_empty|min_length[3]',
        'kapanewon'             => 'permit_empty|min_length[3]',
        'kabupaten_kota'        => 'permit_empty|min_length[3]',
        'provinsi'              => 'permit_empty|min_length[3]',
        'nama_ayah'             => 'permit_empty|min_length[3]',
        'pekerjaan_ayah'        => 'permit_empty|min_length[3]',
        'nama_ibu'              => 'permit_empty|min_length[3]',
        'pekerjaan_ibu'         => 'permit_empty|min_length[3]',
        'nama_wali'             => 'permit_empty|min_length[3]',
        'pekerjaan_wali'        => 'permit_empty|min_length[3]',
        'alamat_wali'           => 'permit_empty|min_length[5]', // <-- ATURAN VALIDASI BARU DITAMBAHKAN
    ];

    protected $validationMessages = [
        'nisn' => [
            'exact_length'  => 'NISN harus 10 digit.',
            'numeric'       => 'NISN harus berupa angka.',
            'is_unique'     => 'NISN ini sudah terdaftar.'
        ],
        'nis' => [
            'max_length'    => 'NIS maksimal 10 digit.',
            'numeric'       => 'NIS harus berupa angka.',
            'is_unique'     => 'NIS ini sudah terdaftar.'
        ],
        'nama_lengkap' => [
            'required'      => 'Nama Lengkap harus diisi.',
            'min_length'    => 'Nama Lengkap minimal 3 karakter.'
        ],
        'kelas_id' => [
            'required'          => 'Kelas harus dipilih.',
            'is_natural_no_zero'=> 'Kelas tidak valid.'
        ],
        'tanggal_lahir' => [
            'valid_date'    => 'Format Tanggal Lahir tidak valid.'
        ],
        'alamat_wali' => [ // <-- PESAN VALIDASI BARU
            'min_length' => 'Alamat Wali minimal 5 karakter.'
        ],
    ];

    protected $skipValidation = true;
    protected $cleanValidationRules = true;
}