<?= $this->extend('layout/kokurikuler_layout'); ?>

<?= $this->section('content'); ?>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
                <div class="card-tools">
                    <a href="<?= base_url('guru/kokurikuler/create'); ?>" class="btn btn-success btn-sm">
                        <i class="fas fa-plus"></i> Tambah Tema Baru
                    </a>
                </div>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('success'); ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <p>Data berikut adalah Rencana Tema Kokurikuler untuk kelas Anda di Tahun Ajaran: <strong><?= esc($tahun_ajaran['nama_tahun'] ?? 'T/A Tidak Ditemukan'); ?></strong></p>

                <table id="dataTable" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th style="width: 5%;">No</th>
                            <th>Nama Kegiatan</th>
                            <th>Semester</th>     <th>Jumlah Tema</th>  
                            <th style="width: 15%;">Aksi</th>     
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1; ?>
                        <?php if (!empty($list_tema)) : ?>
                            <?php foreach ($list_tema as $tema) : ?>
                                <tr>
                                    <td><?= $no++ ?></td>
                                    <td><?= esc($tema['nama_kegiatan']); ?></td>
                                    
                                    <td>
                                        <?php 
                                            // Logika tampilan Semester: 1 = Ganjil, 2 = Genap
                                            if ($tema['semester'] == 1) {
                                                echo 'Semester Ganjil';
                                            } elseif ($tema['semester'] == 2) {
                                                echo 'Semester Genap';
                                            } else {
                                                echo 'N/A';
                                            }
                                        ?>
                                    </td>
                                    
                                    <td>3 Tema</td> 
                                    
                                    <td>
                                        <a href="<?= base_url('guru/kokurikuler/edit/' . $tema['id']); ?>" class="btn btn-secondary">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        <form action="<?= base_url('guru/kokurikuler/delete/' . $tema['id']); ?>" method="post" class="d-inline" onsubmit="return confirm('Apakah Anda yakin ingin menghapus data ini?');">
                                            <?= csrf_field(); ?>
                                            <input type="hidden" name="_method" value="DELETE">
                                            <button type="submit" class="btn btn-danger btn-sm">
                                                <i class="fas fa-trash"></i> Hapus
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else : ?>
                            <tr>
                                <td colspan="5" class="text-center">Belum ada Tema Kokurikuler yang diinput.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>