<?= $this->extend('layout/guru_layout') ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Nilai Akhir Rapor</h3>
            </div>
            <div class="card-body">
                <p>Berikut adalah nilai akhir dan deskripsi yang telah difinalisasi untuk **Semester <?= esc($semester) ?>** Tahun Ajaran **<?= esc($tahun_ajaran) ?>**.</p>
                
                <?php if (empty($nilai_akhir)) : ?>
                    <div class="alert alert-info">Belum ada nilai akhir yang difinalisasi untuk semester ini.</div>
                <?php else : ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover" id="data_table">
                            <thead>
                                <tr>
                                    <th>No.</th>
                                    <th>Nama Siswa</th>
                                    <th>Mata Pelajaran</th>
                                    <th>Nilai Akhir</th>
                                    <th>Deskripsi Nilai</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $no = 1; ?>
                                <?php foreach ($nilai_akhir as $nilai) : ?>
                                    <tr>
                                        <td><?= $no++ ?></td>
                                        <td><?= esc($nilai['nama_siswa']) ?></td>
                                        <td><?= esc($nilai['nama_mapel']) ?></td>
                                        <td><?= esc($nilai['nilai_akhir']) ?></td>
                                        <td><?= esc($nilai['deskripsi_nilai']) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-3">
                        <button onclick="window.print()" class="btn btn-primary"><i class="fas fa-print"></i> Cetak Rapor</button>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>