<?= $this->extend('layout/kokurikuler_layout'); ?> 

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('error')) : ?>
                    <div class="alert alert-danger"><?= session()->getFlashdata('error'); ?></div>
                <?php endif; ?>
                <?php if (session()->getFlashdata('success')) : ?>
                    <div class="alert alert-success"><?= session()->getFlashdata('success'); ?></div>
                <?php endif; ?>

                <?php if (empty($tema)) : ?>
                    <div class="alert alert-warning">Tema Kokurikuler belum diatur untuk kelas ini.</div>
                <?php elseif (empty($list_siswa)) : ?>
                    <div class="alert alert-warning">Tidak ada siswa di kelas ini.</div>
                <?php else : ?>
                    <p>Tema Kokurikuler Aktif: <strong><?= esc($tema['nama_kegiatan']); ?></strong></p>
                    <hr>
                    
                    <form action="<?= base_url('guru/penilaian_kokurikuler/generate_deskripsi'); ?>" method="post">
                        <?= csrf_field(); ?>

                        <div class="mb-3">
                            <label for="siswa_id" class="form-label">Pilih Siswa:</label>
                            <select class="form-control" id="siswa_id" name="siswa_id" required>
                                <option value="">-- Pilih Siswa --</option>
								<option value="all">Semua Siswa di Kelas Ini</option>
                                <?php foreach ($list_siswa as $siswa) : ?>
                                    <option value="<?= esc($siswa['id']); ?>" 
                                            data-panggilan="<?= esc($siswa['nama_panggilan'] ?? $siswa['nama_lengkap']); ?>">
                                        <?= esc($siswa['nama_lengkap']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">Generate Deskripsi</button>
                    </form>

                    <?php $deskripsiData = session()->getFlashdata('deskripsi_data'); ?>
                    <?php $batchResults = session()->getFlashdata('batch_results'); ?>
<?php if (!empty($batchResults)) : ?>
    <div class="mt-4 p-3 border rounded bg-light">
        <h5 class="text-primary">📋 Hasil Generate Massal</h5>
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-sm" style="font-size: 0.9em;">
                <thead>
                    <tr>
                        <th style="width: 5%;">No</th>
                        <th style="width: 20%;">Nama Siswa</th>
                        <th style="width: 10%;">Status</th>
                        <th>Hasil Deskripsi / Pesan Gagal</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $no = 1; ?>
                    <?php foreach ($batchResults as $result) : ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td><?= esc($result['nama']) ?></td>
                            <td class="<?= $result['status'] === 'success' ? 'text-success' : 'text-danger' ?>">
                                <strong><?= $result['status'] === 'success' ? '✅ Sukses' : '❌ Gagal' ?></strong>
                            </td>
                            <td>
                                <?php if ($result['status'] === 'success') : ?>
                                    <span style="font-style: italic;"><?= $result['deskripsi_akhir'] ?></span>
                                <?php else : ?>
                                    <span class="text-danger"><?= esc($result['message']) ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
<?php endif; ?>
					<?php if (!empty($deskripsiData) && $deskripsiData['deskripsi_akhir']) : ?>
                        <div class="mt-4 p-3 border rounded bg-light">
                            <h5 class="text-primary">✨ Hasil Deskripsi Akhir</h5>
                            <p><strong>Nama Siswa:</strong> <?= esc($deskripsiData['siswa_nama']); ?></p>
                            
                            <p>
                                	Skor Tertinggi: Dimensi <?= esc($deskripsiData['max_dimensi']); ?> (Nilai <?= esc($deskripsiData['max_skor']); ?>)<br>
                                <?php if ($deskripsiData['min_dimensi']) : ?>
                                    Skor Terendah: Dimensi <?= esc($deskripsiData['min_dimensi']); ?> (Nilai <?= esc($deskripsiData['min_skor']); ?>)
                                <?php else : ?>
                                    Skor Terendah: Semua dimensi memiliki skor yang sama (<?= esc($deskripsiData['max_skor']); ?>).
                                <?php endif; ?>
                            </p>

                            <div class="alert alert-info">
                                <?= $deskripsiData['deskripsi_akhir']; ?>
                            </div>

                        </div>
                    <?php endif; ?>

                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>