<?php

namespace App\Controllers\Guru;

use App\Controllers\BaseController;
use App\Models\NilaiModel;
use App\Models\SiswaModel;
use App\Models\MataPelajaranModel;
use App\Models\KelasModel;
use App\Models\UserModel;
use App\Models\TpMapelModel;
use App\Models\GuruMapelModel;
use App\Models\TahunAjaranModel;
use App\Models\RentangNilaiModel;
use App\Models\NilaiAkhirMapelModel; // Tambahkan import model ini

class Penilaian extends BaseController
{
    protected $nilaiModel;
    protected $siswaModel;
    protected $mataPelajaranModel;
    protected $kelasModel;
    protected $userModel;
    protected $tpMapelModel;
    protected $guruMapelModel;
    protected $tahunAjaranModel;
    protected $rentangNilaiModel;
    protected $nilaiAkhirMapelModel; // Tambahkan properti ini

    public function __construct()
    {
        $this->nilaiModel = new NilaiModel();
        $this->siswaModel = new SiswaModel();
        $this->mataPelajaranModel = new MataPelajaranModel();
        $this->kelasModel = new KelasModel();
        $this->userModel = new UserModel();
        $this->tpMapelModel = new TpMapelModel();
        $this->guruMapelModel = new GuruMapelModel();
        $this->tahunAjaranModel = new TahunAjaranModel();
        $this->rentangNilaiModel = new RentangNilaiModel();
        $this->nilaiAkhirMapelModel = new NilaiAkhirMapelModel(); // Inisialisasi model ini
    }

    public function index()
    {
        $guru_id = session()->get('user_id');
        $guru_mapel = $this->guruMapelModel
                             ->select('guru_mapel.*, kelas.nama_kelas, mata_pelajaran.nama_mapel')
                             ->join('kelas', 'kelas.id_kelas = guru_mapel.id_kelas')
                             ->join('mata_pelajaran', 'mata_pelajaran.id = guru_mapel.mapel_id')
                             ->where('guru_id', $guru_id)
                             ->findAll();

        $selected_kelas_id = $this->request->getPost('kelas_id') ?? old('kelas_id') ?? '';
        $selected_mapel_id = $this->request->getPost('mapel_id') ?? old('mapel_id') ?? '';
        $selected_semester = $this->request->getPost('semester') ?? old('semester') ?? '';
        $selected_tahun_ajaran_id = $this->request->getPost('tahun_ajaran_id') ?? old('tahun_ajaran_id') ?? '';

        $data_siswa = [];
        $data_penilaian = [];
        $tp_mapel_list = [];

        if (!empty($selected_kelas_id) && !empty($selected_mapel_id) && !empty($selected_semester) && !empty($selected_tahun_ajaran_id)) {
            $data_siswa = $this->siswaModel->where('kelas_id', $selected_kelas_id)->findAll();
            
            // Perubahan di sini: Menambahkan filter semester untuk TP
            $tp_mapel_list = $this->tpMapelModel->where([
                'mapel_id' => $selected_mapel_id,
                'kelas_id' => $selected_kelas_id,
                'semester' => $selected_semester
            ])->findAll();

            foreach ($data_siswa as $siswa) {
                $nilai_harian_per_tp = $this->nilaiModel->where([
                    'siswa_id' => $siswa['id'],
                    'mapel_id' => $selected_mapel_id,
                    'semester' => $selected_semester,
                    'tahun_ajaran_id' => $selected_tahun_ajaran_id,
                    'jenis_penilaian' => 'Harian'
                ])->findAll();
                
                $nilai_harian_indexed = [];
                foreach ($nilai_harian_per_tp as $nilai_tp) {
                    $nilai_harian_indexed[$nilai_tp['tp_id']] = $nilai_tp['nilai'];
                }

                $nilai_pts = $this->nilaiModel->where([
                    'siswa_id' => $siswa['id'],
                    'mapel_id' => $selected_mapel_id,
                    'semester' => $selected_semester,
                    'tahun_ajaran_id' => $selected_tahun_ajaran_id,
                    'jenis_penilaian' => 'PTS/STS'
                ])->first();
                
                $nilai_pas = $this->nilaiModel->where([
                    'siswa_id' => $siswa['id'],
                    'mapel_id' => $selected_mapel_id,
                    'semester' => $selected_semester,
                    'tahun_ajaran_id' => $selected_tahun_ajaran_id,
                    'jenis_penilaian' => 'PAS/SAS'
                ])->first();
                
                $data_penilaian[$siswa['id']] = [
                    'harian' => $nilai_harian_indexed,
                    'pts' => $nilai_pts['nilai'] ?? '',
                    'pas' => $nilai_pas['nilai'] ?? '',
                ];
            }
        }
        
        $data = [
            'title' => 'Input Penilaian',
            'guru_mapel_data' => $guru_mapel,
            'data_siswa' => $data_siswa,
            'data_penilaian' => $data_penilaian,
            'tp_mapel_list' => $tp_mapel_list,
            'tahun_ajaran' => $this->tahunAjaranModel->findAll(),
            'selected_kelas_id' => $selected_kelas_id,
            'selected_mapel_id' => $selected_mapel_id,
            'selected_semester' => $selected_semester,
            'selected_tahun_ajaran_id' => $selected_tahun_ajaran_id,
        ];
        
        return view('guru/penilaian/index', $data);
    }
    
    public function process()
    {
        $data_nilai = $this->request->getPost('nilai');
        $kelasId = $this->request->getPost('kelas_id');
        $mapelId = $this->request->getPost('mapel_id');
        $semester = $this->request->getPost('semester');
        $tahunAjaranId = $this->request->getPost('tahun_ajaran_id');
        
        $guruId = session()->get('user_id');
        
        $tahunAjaranData = $this->tahunAjaranModel->find($tahunAjaranId);
        $tahunAjaranNama = $tahunAjaranData['nama_tahun'] ?? null;
        
        if (empty($data_nilai)) {
             session()->setFlashdata('error', 'Tidak ada data nilai yang dikirim.');
             return redirect()->to(base_url('guru/penilaian'));
        }
        
        $db = \Config\Database::connect();
        $db->transBegin();
        
        try {
            foreach ($data_nilai as $siswa_id => $jenis_nilai) {
                foreach ($jenis_nilai as $jenis_penilaian => $nilai_data) {
                    if ($jenis_penilaian === 'Harian' && is_array($nilai_data)) {
                        foreach ($nilai_data as $tp_id => $nilai) {
                             $data_to_save = [
                                 'siswa_id' => $siswa_id,
                                 'guru_id' => $guruId,
                                 'kelas_id' => $kelasId,
                                 'mapel_id' => $mapelId,
                                 'semester' => $semester,
                                 'tahun_ajaran_id' => $tahunAjaranId,
                                 'tahun_ajaran' => $tahunAjaranNama,
                                 'jenis_penilaian' => 'Harian',
                                 'tp_id' => $tp_id,
                                 'nilai' => $nilai,
                             ];
                             $existing_nilai = $this->nilaiModel->where([
                                 'siswa_id' => $siswa_id,
                                 'mapel_id' => $mapelId,
                                 'semester' => $semester,
                                 'tahun_ajaran_id' => $tahunAjaranId,
                                 'jenis_penilaian' => 'Harian',
                                 'tp_id' => $tp_id,
                             ])->first();
                            
                             if ($existing_nilai) {
                                 $this->nilaiModel->update($existing_nilai['id'], $data_to_save);
                             } else {
                                 $this->nilaiModel->insert($data_to_save);
                             }
                        }
                    } else {
                        $data_to_save = [
                           'siswa_id' => $siswa_id,
                           'guru_id' => $guruId,
                           'kelas_id' => $kelasId,
                           'mapel_id' => $mapelId,
                           'semester' => $semester,
                           'tahun_ajaran_id' => $tahunAjaranId,
                           'tahun_ajaran' => $tahunAjaranNama,
                           'jenis_penilaian' => $jenis_penilaian,
                           'tp_id' => null,
                           'nilai' => $nilai_data,
                        ];

                        $existing_nilai = $this->nilaiModel->where([
                             'siswa_id' => $siswa_id,
                             'mapel_id' => $mapelId,
                             'semester' => $semester,
                             'tahun_ajaran_id' => $tahunAjaranId,
                             'jenis_penilaian' => $jenis_penilaian,
                         ])->first();
                        
                        if ($existing_nilai) {
                            $this->nilaiModel->update($existing_nilai['id'], $data_to_save);
                        } else {
                            $this->nilaiModel->insert($data_to_save);
                        }
                    }
                }
            }
        
            if ($db->transStatus() === false) {
                $db->transRollback();
                session()->setFlashdata('error', 'Gagal menyimpan data nilai. Terjadi kesalahan pada database.');
            } else {
                $db->transCommit();
                session()->setFlashdata('success', 'Data nilai berhasil disimpan.');
            }
        } catch (\Exception $e) {
            $db->transRollback();
            session()->setFlashdata('error', 'Gagal menyimpan data nilai: ' . $e->getMessage());
        }
        
        return redirect()->to(base_url('guru/penilaian'));
    }

    public function hitungNilaiAkhir()
    {
        $kelasId = $this->request->getVar('kelas_id');
        $mapelId = $this->request->getVar('mapel_id');
        $semester = $this->request->getVar('semester');
        $tahunAjaranId = $this->request->getVar('tahun_ajaran_id');

        if (empty($kelasId) || empty($mapelId) || empty($semester) || empty($tahunAjaranId)) {
            session()->setFlashdata('error', 'Pilih kelas, mata pelajaran, semester, dan tahun ajaran untuk menghitung nilai akhir.');
            return redirect()->to(base_url('guru/penilaian'));
        }

        $siswaList = $this->siswaModel->where('kelas_id', $kelasId)->findAll();
        
        $nilaiAkhirSiswa = [];

        foreach ($siswaList as $siswa) {
            $siswaId = $siswa['id'];

            $nilaiHarian = $this->nilaiModel->where([
                'siswa_id' => $siswaId,
                'mapel_id' => $mapelId,
                'semester' => $semester,
                'tahun_ajaran_id' => $tahunAjaranId,
                'jenis_penilaian' => 'Harian'
            ])->findAll();

            $rerataNilaiHarian = 0;
            if (!empty($nilaiHarian)) {
                $totalNilaiHarian = array_sum(array_column($nilaiHarian, 'nilai'));
                $rerataNilaiHarian = $totalNilaiHarian / count($nilaiHarian);
            }

            $nilaiPts = $this->nilaiModel->where([
                'siswa_id' => $siswaId,
                'mapel_id' => $mapelId,
                'semester' => $semester,
                'tahun_ajaran_id' => $tahunAjaranId,
                'jenis_penilaian' => 'PTS/STS'
            ])->first();
            $nilaiPtsValue = $nilaiPts['nilai'] ?? 0;

            $nilaiPas = $this->nilaiModel->where([
                'siswa_id' => $siswaId,
                'mapel_id' => $mapelId,
                'semester' => $semester,
                'tahun_ajaran_id' => $tahunAjaranId,
                'jenis_penilaian' => 'PAS/SAS'
            ])->first();
            $nilaiPasValue = $nilaiPas['nilai'] ?? 0;

            if ($rerataNilaiHarian > 0 || $nilaiPtsValue > 0 || $nilaiPasValue > 0) {
                $nilaiAkhir = ($rerataNilaiHarian + $nilaiPtsValue + $nilaiPasValue) / 3;
            } else {
                $nilaiAkhir = 0;
            }

            $nilaiAkhirSiswa[] = [
                'siswa_id' => $siswaId,
                'nama_siswa' => $siswa['nama_lengkap'],
                'rerata_harian' => round($rerataNilaiHarian, 2),
                'nilai_pts' => $nilaiPtsValue,
                'nilai_pas' => $nilaiPasValue,
                'nilai_akhir' => round($nilaiAkhir, 2)
            ];
        }

        $data = [
            'title' => 'Nilai Akhir Mata Pelajaran',
            'nilai_akhir_siswa' => $nilaiAkhirSiswa,
        ];

        return view('guru/penilaian/nilai_akhir_view', $data);
    }
    
    public function nilaiAkhirRapor()
    {
        if (session()->get('role') !== 'guru') {
            session()->setFlashdata('error', 'Akses tidak sah.');
            return redirect()->to(base_url('guru/penilaian'));
        }

        $guru_id = session()->get('user_id');
        $tahun_ajaran = $this->tahunAjaranModel->where('aktif', 1)->first();
        
        if (!$tahun_ajaran) {
            session()->setFlashdata('error', 'Tidak ada tahun ajaran yang aktif.');
            return redirect()->back();
        }
        
        $tahun_ajaran_id = $tahun_ajaran['id'];
        $semester = $tahun_ajaran['semester'];
        
        $nilai_akhir_siswa = [];
        
        // Cek apakah guru yang login adalah wali kelas
        // Perbaikan: Menggunakan 'guru_kelas_id' sesuai dengan database Anda
        $wali_kelas_data = $this->kelasModel->where('guru_kelas_id', $guru_id)->first();

        if ($wali_kelas_data) {
            // Jika guru adalah wali kelas, ambil semua nilai akhir untuk kelas tersebut
            $kelas_id = $wali_kelas_data['id_kelas'];
            $nilai_akhir_siswa = $this->nilaiAkhirMapelModel
                ->select('nilai_akhir_mapel.nilai_akhir, nilai_akhir_mapel.deskripsi_nilai, siswa.nama_lengkap, mata_pelajaran.nama_mapel, kelas.nama_kelas')
                ->join('siswa', 'siswa.id = nilai_akhir_mapel.siswa_id')
                ->join('mata_pelajaran', 'mata_pelajaran.id = nilai_akhir_mapel.mapel_id')
                ->join('kelas', 'kelas.id_kelas = nilai_akhir_mapel.kelas_id')
                ->where('nilai_akhir_mapel.kelas_id', $kelas_id)
                ->where('nilai_akhir_mapel.tahun_ajaran_id', $tahun_ajaran_id)
                ->where('nilai_akhir_mapel.semester', $semester)
                ->findAll();

        } else {
            // Jika guru bukan wali kelas, gunakan logika sebelumnya (ambil mapel yang diampu)
            $nilai_akhir_siswa = $this->nilaiAkhirMapelModel
                ->select('nilai_akhir_mapel.nilai_akhir, nilai_akhir_mapel.deskripsi_nilai, siswa.nama_lengkap, mata_pelajaran.nama_mapel, kelas.nama_kelas')
                ->join('guru_mapel', 'guru_mapel.mapel_id = nilai_akhir_mapel.mapel_id AND guru_mapel.id_kelas = nilai_akhir_mapel.kelas_id')
                ->join('siswa', 'siswa.id = nilai_akhir_mapel.siswa_id')
                ->join('mata_pelajaran', 'mata_pelajaran.id = nilai_akhir_mapel.mapel_id')
                ->join('kelas', 'kelas.id_kelas = nilai_akhir_mapel.kelas_id')
                ->where('guru_mapel.guru_id', $guru_id)
                ->where('nilai_akhir_mapel.tahun_ajaran_id', $tahun_ajaran_id)
                ->where('nilai_akhir_mapel.semester', $semester)
                ->findAll();
        }

        $data = [
            'title' => 'Nilai Akhir Rapor',
            'nilai_akhir_siswa' => $nilai_akhir_siswa,
        ];

        return view('guru/penilaian/nilai_akhir_rapor', $data);
    }

    public function finalisasiNilai()
    {
        if (session()->get('role') !== 'guru' || strtolower($this->request->getMethod()) !== 'post') {
            session()->setFlashdata('error', 'Akses tidak sah.');
            return redirect()->to(base_url('guru/penilaian'));
        }

        $guru_id = session()->get('user_id');
        $tahun_ajaran = $this->tahunAjaranModel->where('aktif', 1)->first();
        if (!$tahun_ajaran) {
            session()->setFlashdata('error', 'Tidak ada tahun ajaran yang aktif.');
            return redirect()->back();
        }
        $tahun_ajaran_id = $tahun_ajaran['id'];
        $semester = $tahun_ajaran['semester'];

        $guru_mapel_assignments = $this->guruMapelModel
            ->select('guru_mapel.mapel_id, guru_mapel.id_kelas, kelas.nama_kelas, mata_pelajaran.nama_mapel')
            ->join('kelas', 'kelas.id_kelas = guru_mapel.id_kelas')
            ->join('mata_pelajaran', 'mata_pelajaran.id = guru_mapel.mapel_id')
            ->where('guru_mapel.guru_id', $guru_id)
            ->findAll();

        if (empty($guru_mapel_assignments)) {
            session()->setFlashdata('error', 'Anda tidak mengampu mata pelajaran apapun.');
            return redirect()->back();
        }

        $kelas_ids = array_column($guru_mapel_assignments, 'id_kelas');
        $siswa_list = $this->siswaModel->whereIn('kelas_id', $kelas_ids)->findAll();
        $siswa_by_kelas = [];
        foreach ($siswa_list as $siswa) {
            $siswa_by_kelas[$siswa['kelas_id']][] = $siswa;
        }

        $tp_list = $this->tpMapelModel
            ->whereIn('kelas_id', $kelas_ids)
            ->whereIn('mapel_id', array_column($guru_mapel_assignments, 'mapel_id'))
            ->where('tahun_ajaran_id', $tahun_ajaran_id)
            ->where('semester', $semester)
            ->findAll();
        $tp_by_mapel_kelas = [];
        foreach ($tp_list as $tp) {
            $tp_by_mapel_kelas[$tp['mapel_id']][$tp['kelas_id']][] = $tp;
        }

        $processed_count = 0;
        $rentang_nilai = $this->rentangNilaiModel->findAll();

        $this->nilaiAkhirMapelModel
            ->where('tahun_ajaran_id', $tahun_ajaran_id)
            ->where('semester', $semester)
            ->whereIn('mapel_id', array_column($guru_mapel_assignments, 'mapel_id'))
            ->whereIn('kelas_id', array_column($guru_mapel_assignments, 'id_kelas'))
            ->delete();

        foreach ($guru_mapel_assignments as $assignment) {
            $mapel_id = $assignment['mapel_id'];
            $kelas_id = $assignment['id_kelas'];

            if (!isset($siswa_by_kelas[$kelas_id]) || !isset($tp_by_mapel_kelas[$mapel_id][$kelas_id])) {
                continue;
            }

            $current_tps = $tp_by_mapel_kelas[$mapel_id][$kelas_id];
            
            $tp_indexed = [];
            foreach ($current_tps as $tp) {
                $tp_indexed[$tp['id']] = $tp['deskripsi_tp'];
            }

            $nilai_harian_list = $this->nilaiModel
                ->where('tahun_ajaran_id', $tahun_ajaran_id)
                ->where('semester', $semester)
                ->where('mapel_id', $mapel_id)
                ->where('kelas_id', $kelas_id)
                ->where('jenis_penilaian', 'Harian')
                ->findAll();

            $nilai_harian_by_siswa_tp = [];
            foreach ($nilai_harian_list as $nilai) {
                if (isset($nilai['tp_id'])) {
                    $nilai_harian_by_siswa_tp[$nilai['siswa_id']][$nilai['tp_id']][] = $nilai['nilai'];
                }
            }

            foreach ($siswa_by_kelas[$kelas_id] as $siswa) {
                $siswa_id = $siswa['id'];
                $total_nilai_harian = 0;
                $count_nilai_harian = 0;

                // Mendapatkan nilai tertinggi dan terendah untuk deskripsi
                $nilai_tertinggi = ['nilai' => -1, 'tp_id' => null];
                $nilai_terendah = ['nilai' => 101, 'tp_id' => null];

                foreach ($current_tps as $tp) {
                    $tp_id = $tp['id'];
                    if (isset($nilai_harian_by_siswa_tp[$siswa_id][$tp_id])) {
                        $total_nilai_harian += array_sum($nilai_harian_by_siswa_tp[$siswa_id][$tp_id]);
                        $count_nilai_harian += count($nilai_harian_by_siswa_tp[$siswa_id][$tp_id]);

                        $tp_min_val = min($nilai_harian_by_siswa_tp[$siswa_id][$tp_id]);
                        $tp_max_val = max($nilai_harian_by_siswa_tp[$siswa_id][$tp_id]);

                        if ($tp_max_val > $nilai_tertinggi['nilai']) {
                            $nilai_tertinggi['nilai'] = $tp_max_val;
                            $nilai_tertinggi['tp_id'] = $tp_id;
                        }
                        if ($tp_min_val < $nilai_terendah['nilai']) {
                            $nilai_terendah['nilai'] = $tp_min_val;
                            $nilai_terendah['tp_id'] = $tp_id;
                        }
                    }
                }

                $rerata_harian = $count_nilai_harian > 0 ? $total_nilai_harian / $count_nilai_harian : 0;
                $nilai_pts = $this->nilaiModel
                    ->where('tahun_ajaran_id', $tahun_ajaran_id)
                    ->where('semester', $semester)
                    ->where('mapel_id', $mapel_id)
                    ->where('kelas_id', $kelas_id)
                    ->where('siswa_id', $siswa_id)
                    ->where('jenis_penilaian', 'PTS/STS')
                    ->first();

                $nilai_pas = $this->nilaiModel
                    ->where('tahun_ajaran_id', $tahun_ajaran_id)
                    ->where('semester', $semester)
                    ->where('mapel_id', $mapel_id)
                    ->where('kelas_id', $kelas_id)
                    ->where('siswa_id', $siswa_id)
                    ->where('jenis_penilaian', 'PAS/SAS')
                    ->first();

                $nilai_pts_val = $nilai_pts ? $nilai_pts['nilai'] : 0;
                $nilai_pas_val = $nilai_pas ? $nilai_pas['nilai'] : 0;

                $nilai_akhir = ($rerata_harian + $nilai_pts_val + $nilai_pas_val) / 3;
                
                $deskripsi_nilai = "Deskripsi belum tersedia.";
                if ($count_nilai_harian > 0) {
                    $kategori_tertinggi = '';
                    $kategori_terendah = '';

                    foreach ($rentang_nilai as $kat) {
                        if ($nilai_tertinggi['nilai'] >= $kat['nilai_minimal'] && $nilai_tertinggi['nilai'] <= $kat['nilai_maksimal']) {
                            $kategori_tertinggi = strtolower($kat['kategori']);
                        }
                        if ($nilai_terendah['nilai'] >= $kat['nilai_minimal'] && $nilai_terendah['nilai'] <= $kat['nilai_maksimal']) {
                            $kategori_terendah = strtolower($kat['kategori']);
                        }
                    }

                    $tp_tertinggi = isset($tp_indexed[$nilai_tertinggi['tp_id']]) ? $tp_indexed[$nilai_tertinggi['tp_id']] : 'tidak ada';
                    $tp_terendah = isset($tp_indexed[$nilai_terendah['tp_id']]) ? $tp_indexed[$nilai_terendah['tp_id']] : 'tidak ada';
                    
                    $deskripsi_nilai = "Ananda {$siswa['nama_lengkap']} menunjukkan penguasaan materi {$kategori_terendah} pada {$tp_terendah}, serta sudah menguasai materi dengan {$kategori_tertinggi} pada {$tp_tertinggi}.";
                }

                $data_nilai_akhir = [
                    'siswa_id' => $siswa_id,
                    'mapel_id' => $mapel_id,
                    'kelas_id' => $kelas_id,
                    'tahun_ajaran_id' => $tahun_ajaran_id,
                    'semester' => $semester,
                    'nilai_akhir' => number_format($nilai_akhir, 2),
                    'deskripsi_nilai' => $deskripsi_nilai,
                ];

                $this->nilaiAkhirMapelModel->insert($data_nilai_akhir);
                $processed_count++;
            }
        }
        
        if ($processed_count > 0) {
            session()->setFlashdata('success', "Finalisasi nilai rapor berhasil. Diproses $processed_count nilai akhir.");
        } else {
            session()->setFlashdata('error', 'Tidak ada data nilai yang ditemukan untuk difinalisasi.');
        }

        return redirect()->to(base_url('guru/penilaian/nilaiAkhirRapor'));
    }
    
    public function deskripsi()
    {
        $guru_id = session()->get('user_id');
        $guru_mapel = $this->guruMapelModel
                             ->select('guru_mapel.*, kelas.nama_kelas, mata_pelajaran.nama_mapel')
                             ->join('kelas', 'kelas.id_kelas = guru_mapel.id_kelas')
                             ->join('mata_pelajaran', 'mata_pelajaran.id = guru_mapel.mapel_id')
                             ->where('guru_id', $guru_id)
                             ->findAll();

        $selected_kelas_id = $this->request->getPost('kelas_id') ?? old('kelas_id') ?? '';
        $selected_mapel_id = $this->request->getPost('mapel_id') ?? old('mapel_id') ?? '';
        $selected_semester = $this->request->getPost('semester') ?? old('semester') ?? '';
        $selected_tahun_ajaran_id = $this->request->getPost('tahun_ajaran_id') ?? old('tahun_ajaran_id') ?? '';

        $data_siswa = [];
        $data_deskripsi = [];
        $tp_mapel_list = [];
        $rentang_nilai = $this->rentangNilaiModel->findAll();

        $kategori_nilai = [];
        foreach ($rentang_nilai as $rn) {
            $kategori_nilai[] = $rn;
        }

        if (!empty($selected_kelas_id) && !empty($selected_mapel_id) && !empty($selected_semester) && !empty($selected_tahun_ajaran_id)) {
            $data_siswa = $this->siswaModel->where('kelas_id', $selected_kelas_id)->findAll();
            
            // Perubahan di sini: Menambahkan filter semester untuk TP
            $tp_mapel_list = $this->tpMapelModel->where([
                'mapel_id' => $selected_mapel_id,
                'kelas_id' => $selected_kelas_id,
                'semester' => $selected_semester
            ])->findAll();
            
            $tp_indexed = [];
            foreach ($tp_mapel_list as $tp) {
                $tp_indexed[$tp['id']] = $tp['deskripsi_tp'];
            }

            foreach ($data_siswa as $siswa) {
                $nilai_harian = $this->nilaiModel->where([
                    'siswa_id' => $siswa['id'],
                    'mapel_id' => $selected_mapel_id,
                    'semester' => $selected_semester,
                    'tahun_ajaran_id' => $selected_tahun_ajaran_id,
                    'jenis_penilaian' => 'Harian'
                ])->findAll();
                
                $nilai_tertinggi = ['nilai' => -1, 'tp_id' => null];
                $nilai_terendah = ['nilai' => 101, 'tp_id' => null];

                if (!empty($nilai_harian)) {
                    foreach ($nilai_harian as $nilai) {
                        if ($nilai['nilai'] > $nilai_tertinggi['nilai']) {
                            $nilai_tertinggi['nilai'] = $nilai['nilai'];
                            $nilai_tertinggi['tp_id'] = $nilai['tp_id'];
                        }
                        if ($nilai['nilai'] < $nilai_terendah['nilai']) {
                            $nilai_terendah['nilai'] = $nilai['nilai'];
                            $nilai_terendah['tp_id'] = $nilai['tp_id'];
                        }
                    }
                }
                
                $kategori_tertinggi = '';
                $kategori_terendah = '';

                foreach ($kategori_nilai as $kat) {
                    if ($nilai_tertinggi['nilai'] >= $kat['nilai_minimal'] && $nilai_tertinggi['nilai'] <= $kat['nilai_maksimal']) {
                        $kategori_tertinggi = strtolower($kat['kategori']);
                    }
                    if ($nilai_terendah['nilai'] >= $kat['nilai_minimal'] && $nilai_terendah['nilai'] <= $kat['nilai_maksimal']) {
                        $kategori_terendah = strtolower($kat['kategori']);
                    }
                }

                $tp_tertinggi = isset($tp_indexed[$nilai_tertinggi['tp_id']]) ? $tp_indexed[$nilai_tertinggi['tp_id']] : 'tidak ada';
                $tp_terendah = isset($tp_indexed[$nilai_terendah['tp_id']]) ? $tp_indexed[$nilai_terendah['tp_id']] : 'tidak ada';

                if (!empty($nilai_harian)) {
                    $deskripsi = "Ananda {$siswa['nama_panggilan']} menunjukkan penguasaan materi {$kategori_terendah} pada {$tp_terendah}, serta sudah menguasai materi dengan {$kategori_tertinggi} pada {$tp_tertinggi}.";
                } else {
                    $deskripsi = 'Data nilai harian belum tersedia.';
                }

                $data_deskripsi[$siswa['id']] = $deskripsi;
            }
        }
        
        $data = [
            'title' => 'Deskripsi Nilai Per Mapel',
            'guru_mapel_data' => $guru_mapel,
            'data_siswa' => $data_siswa,
            'data_deskripsi' => $data_deskripsi,
            'tahun_ajaran' => $this->tahunAjaranModel->findAll(),
            'selected_kelas_id' => $selected_kelas_id,
            'selected_mapel_id' => $selected_mapel_id,
            'selected_semester' => $selected_semester,
            'selected_tahun_ajaran_id' => $selected_tahun_ajaran_id,
        ];
        
        return view('guru/penilaian/deskripsi', $data);
    }
}
