<?= $this->extend('layout/admin_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('errors')) : ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <ul>
                            <?php foreach (session()->getFlashdata('errors') as $error) : ?>
                                <li><?= esc($error); ?></li>
                            <?php endforeach; ?>
                        </ul>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>
                <form action="<?= base_url('admin/ekstrakurikuler/update/' . $ekskul['id']); ?>" method="post">
                    <?= csrf_field(); ?>
                    <div class="form-group">
                        <label for="nama_ekskul">Nama Ekstrakurikuler</label>
                        <input type="text" class="form-control <?= (session('validation') && session('validation')->hasError('nama_ekskul')) ? 'is-invalid' : ''; ?>" id="nama_ekskul" name="nama_ekskul" value="<?= old('nama_ekskul', $ekskul['nama_ekskul']); ?>">
                        <?php if (session('validation') && session('validation')->hasError('nama_ekskul')) : ?>
                            <div class="invalid-feedback">
                                <?= session('validation')->getError('nama_ekskul'); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="penanggung_jawab_id">Penanggung Jawab</label>
                        <select name="penanggung_jawab_id" id="penanggung_jawab_id" class="form-control">
                            <option value="">-- Pilih Guru --</option>
                            <?php foreach ($gurus as $guru) : ?>
                                <option value="<?= esc($guru['id']); ?>" <?= (old('penanggung_jawab_id', $ekskul['penanggung_jawab_id']) == $guru['id']) ? 'selected' : ''; ?>>
                                    <?= esc($guru['nama']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                    <a href="<?= base_url('admin/ekstrakurikuler'); ?>" class="btn btn-secondary">Batal</a>
                </form>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>
