<?= $this->extend('layout/admin_layout') ?>

<?= $this->section('title') ?><?= $title ?><?= $this->endSection() ?>

<?= $this->section('content') ?>
<h1><?= esc($title) ?></h1>
<p>Isi formulir di bawah ini untuk menambahkan kelas baru.</p>

<form action="<?= base_url('admin/kelas/save') ?>" method="post">
    <?= csrf_field() ?>

    <label for="nama_kelas">Nama Kelas:</label>
    <input type="text" id="nama_kelas" name="nama_kelas"
           value="<?= old('nama_kelas') ?>"
           class="<?= ($validation->hasError('nama_kelas')) ? 'is-invalid' : ''; ?>" required>
    <?php if ($validation->hasError('nama_kelas')): ?>
        <p class="text-danger"><?= $validation->getError('nama_kelas') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="guru_kelas_id">Guru Kelas (ID):</label>
    <input type="number" id="guru_kelas_id" name="guru_kelas_id"
           value="<?= old('guru_kelas_id') ?>"
           class="<?= ($validation->hasError('guru_kelas_id')) ? 'is-invalid' : ''; ?>">
    <?php if ($validation->hasError('guru_kelas_id')): ?>
        <p class="text-danger"><?= $validation->getError('guru_kelas_id') ?></p>
    <?php endif; ?>
    <br><br>

    <label for="tahun_ajaran_id">Tahun Ajaran (ID):</label>
    <input type="number" id="tahun_ajaran_id" name="tahun_ajaran_id"
           value="<?= old('tahun_ajaran_id') ?>"
           class="<?= ($validation->hasError('tahun_ajaran_id')) ? 'is-invalid' : ''; ?>" required>
    <?php if ($validation->hasError('tahun_ajaran_id')): ?>
        <p class="text-danger"><?= $validation->getError('tahun_ajaran_id') ?></p>
    <?php endif; ?>
    <br><br>

    <button type="submit" class="btn btn-success">Simpan Kelas</button>
    <a href="<?= base_url('admin/kelas') ?>" class="btn btn-secondary">Batal</a>
</form>

<style>
    /* Styling sederhana untuk validasi error */
    .is-invalid {
        border-color: #dc3545; /* Merah untuk input yang salah */
    }
    .text-danger {
        color: #dc3545;
        font-size: 0.875em;
        margin-top: 5px;
    }
</style>
<?= $this->endSection() ?>