<?= $this->extend('layout/guru_layout'); ?>

<?= $this->section('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?= $title; ?></h3>
            </div>
            <div class="card-body">
                <a href="<?= base_url('guru/penilaian'); ?>" class="btn btn-secondary mb-3">Kembali</a>
                <table class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Siswa</th>
                            <th>Mata Pelajaran</th>
                            <th>Kelas</th>
                            <th>Nilai Akhir</th>
                            <th>Deskripsi Nilai</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($nilai_akhir_siswa)): ?>
                            <tr>
                                <td colspan="6" class="text-center">Belum ada nilai akhir yang difinalisasi.</td>
                            </tr>
                        <?php else: ?>
                            <?php $no = 1; ?>
                            <?php foreach ($nilai_akhir_siswa as $nilai) : ?>
                                <tr>
                                    <td><?= $no++ ?></td>
                                    <td><?= esc($nilai['nama_lengkap']) ?></td>
                                    <td><?= esc($nilai['nama_mapel']) ?></td>
                                    <td><?= esc($nilai['nama_kelas']) ?></td>
                                    <td><strong><?= esc($nilai['nilai_akhir']) ?></strong></td>
                                    <td><?= esc($nilai['deskripsi_nilai']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection(); ?>
