<!DOCTYPE html>
<html>
<head>
    <title>Daftar Pengambilan Rapor</title>
    <style>
        body {
            font-family: 'Times New Roman', Times, serif;
            font-size: 11pt;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 100%;
            padding: 10mm 15mm 10mm 0mm;
            box-sizing: border-box;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h3, .header p {
            margin: 0;
            padding: 0;
        }
        .header h3 {
            font-size: 14pt;
            font-weight: bold;
        }
        table.data-siswa {
            width: 100%;
            border-collapse: collapse;
            font-size: 11pt;
            margin-top: 20px;
        }
        table.data-siswa th, table.data-siswa td {
            border: 1px solid black;
            padding: 8px;
            text-align: center;
        }
        table.data-siswa th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .text-left {
            text-align: left;
        }
        
        /* Gaya untuk tabel tanda tangan yang baru */
        .ttd-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 50px;
        }
        .ttd-table td {
            border: none;
            padding: 10px;
            text-align: center;
            vertical-align: top;
        }
        .nama-gelar {
            margin-top: 60px;
            border-bottom: 1px solid black;
            display: inline-block;
            padding: 0 5px;
            margin-bottom: 0px;
        }
        .nip {
            margin-top: 0px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h3>PENGAMBILAN RAPOR</h3>
            <p>Tahun Ajaran: <?= esc($tahunAjaran['nama_tahun'] ?? '-') ?></p>
            <p>Kelas: <?= esc($kelas['nama_kelas'] ?? '-') ?></p>
        </div>
        <table class="data-siswa">
            <thead>
                <tr>
                    <th style="width: 5%;">No</th>
                    <th style="width: 50%;">Nama Siswa</th>
                    <th style="width: 45%;">Tanda Tangan</th>
                </tr>
            </thead>
            <tbody>
                <?php $no = 1; ?>
                <?php if (!empty($siswaList)) : ?>
                    <?php foreach ($siswaList as $siswa) : ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td class="text-left"><?= esc($siswa['nama_lengkap'] ?? '-') ?></td>
                            <td></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else : ?>
                    <tr>
                        <td colspan="3">Tidak ada data siswa ditemukan.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <table class="ttd-table">
            <tr>
                <td style="width: 60%;"></td> <td style="width: 40%;">
                    <p>Guru Kelas,</p>
                    <p class="nama-gelar"><?= esc($waliKelas['nama']) ?></p>
                    <p class="nip">NIP. <?= esc($waliKelas['nip'] ?? '-') ?></p>
                </td>
            </tr>
        </table>
    </div>
</body>
</html>
