<!DOCTYPE html>
<html>
<head>
    <title>Rapor Siswa</title>
    <style>
        body {
            font-family: 'Times New Roman', Times, serif;
            font-size: 11pt;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 100%;
            /* Menggunakan padding yang disesuaikan */
            padding: 10mm 15mm 10mm 0mm;
            box-sizing: border-box;
        }
        .header, .footer {
            width: 100%;
        }
        .header {
            margin-bottom: 20px;
        }
        .header .school-info {
            overflow: hidden;
            text-align: center;
        }
        .header h1, .header h3 {
            margin: 0;
            padding: 0;
        }
        .divider {
            border-bottom: 2px solid black;
            margin: 10px 0;
        }
        .student-data {
            width: 100%;
            margin-top: 15px;
            margin-bottom: 25px;
        }
        .student-data table {
            width: 100%;
            border-collapse: collapse;
        }
        .student-data td {
            padding: 2px 0;
        }
        .section-title {
            font-size: 12pt;
            font-weight: bold;
            margin-bottom: 5px;
        }
        table.nilai, table.ekskul, table.catatan {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table.nilai th, table.nilai td, table.ekskul th, table.ekskul td, table.catatan th, table.catatan td {
            border: 1px solid black;
            padding: 5px;
            word-wrap: break-word; 
            vertical-align: top;
        }
        table.nilai th, table.ekskul th {
            background-color: #f2f2f2;
            text-align: center;
        }

        /* Gaya untuk tabel berdampingan */
        .section-table-layout {
            width: 100%;
            border-collapse: collapse;
        }
        .section-table-layout td {
            padding: 0;
            vertical-align: top;
        }
        .section-table-layout td > * {
            margin-bottom: 20px;
        }
        table.kehadiran {
            width: 80%;
            border-collapse: collapse;
        }
        table.kehadiran th, table.kehadiran td {
            border: 1px solid black;
            padding: 5px;
            vertical-align: top;
            word-wrap: break-word;
        }
        table.catatan-wali-kelas {
            width: 80%;
            border-collapse: collapse;
        }
        table.catatan-wali-kelas td {
            border: 1px solid black;
            padding: 10px;
            vertical-align: top;
            word-wrap: break-word;
        }

        /* Gaya baru untuk tabel tanda tangan */
        .ttd-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 50px;
        }
        .ttd-table td {
            border: none;
            padding: 10px;
            text-align: center;
            vertical-align: top;
        }
        .nama-gelar {
            margin-top: 50px;
            border-bottom: 1px solid black;
            display: inline-block;
            padding: 0 5px;
            margin-bottom: 0px;
        }
        .nip {
            margin-top: 0; /* Jarak antara nama dan NIP dipersempit */
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="school-info">
                <h2>RAPOR PESERTA DIDIK DAN PROFIL PESERTA DIDIK</h2>
            </div>
            <br>
            <div class="divider"></div>
        </div>

        <div class="student-data">
            <table>
                <tr>
                    <td>Nama Peserta Didik</td>
                    <td>: <?= esc($siswa['nama_lengkap'] ?? '-') ?></td>
                    <td>Kelas</td>
                    <td>: <?= esc($kelas['nama_kelas'] ?? '-') ?></td>
                </tr>
                <tr>
                    <td>NISN / NIS</td>
                    <td>: <?= esc($siswa['nisn'] ?? '-') ?> / <?= esc($siswa['nis'] ?? '-') ?></td>
                    <td>Fase</td>
                    <td>: <?= esc($fase ?? '-') ?></td>
                </tr>
                <tr>
                    <td>Nama Sekolah</td>
                    <td>: <?= esc($sekolah['nama_sekolah'] ?? '-') ?></td>
                    <td>Semester</td>
                    <td>: <?= esc($tahunAjaran['semester'] ?? '-') ?></td>
                </tr>
                <tr>
                    <td>Alamat Sekolah</td>
                    <td>: <?= esc($sekolah['alamat'] ?? '-') ?></td>
                    <td>Tahun Ajaran</td>
                    <td>: <?= esc($tahunAjaran['nama_tahun'] ?? '-') ?></td>
                </tr>
            </table>
        </div>

        <p class="section-title">A. Nilai Akademik</p>
        <table class="nilai">
            <thead>
                <tr>
                    <th style="width: 5%;">No</th>
                    <th style="width: 25%;">Mata Pelajaran</th>
                    <th style="width: 10%;">Nilai Akhir</th>
                    <th>Capaian Kompetensi</th>
                </tr>
            </thead>
            <tbody>
                <?php $no = 1; ?>
                <?php if (!empty($nilaiMapel)) : ?>
                    <?php foreach ($nilaiMapel as $nilai) : ?>
                        <tr>
                            <td style="text-align: center;"><?= $no++ ?></td>
                            <td><?= esc($nilai['nama_mapel']) ?></td>
                            <td style="text-align: center;"><?= esc($nilai['nilai_akhir']) ?></td>
                            <td><?= esc($nilai['deskripsi_nilai']) ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else : ?>
                    <tr>
                        <td colspan="4" style="text-align: center;">Tidak ada data nilai akademik.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <p class="section-title">B. Ekstrakurikuler</p>
        <table class="ekskul">
            <thead>
                <tr>
                    <th style="width: 5%;">No</th>
                    <th style="width: 25%;">Ekstrakurikuler</th>
                    <th>Keterangan</th>
                </tr>
            </thead>
            <tbody>
                <?php $no = 1; ?>
                <?php if (!empty($ekstrakurikuler)) : ?>
                    <?php foreach ($ekstrakurikuler as $ekskul) : ?>
                        <tr>
                            <td style="text-align: center;"><?= $no++ ?></td>
                            <td><?= esc($ekskul['nama_ekskul']) ?></td>
                            <td><?= esc($ekskul['deskripsi_ekskul']) ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else : ?>
                    <tr>
                        <td colspan="3" style="text-align: center;">Tidak ada data ekstrakurikuler.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        
        <table class="section-table-layout">
            <tr>
                <td style="width: 50%;">
                    <p class="section-title">C. Ketidakhadiran</p>
                    <table class="kehadiran">
                        <tbody>
                            <tr>
                                <td>Sakit</td>
                                <td>: <?= esc($kehadiran['sakit'] ?? 0) ?> hari</td>
                            </tr>
                            <tr>
                                <td>Izin</td>
                                <td>: <?= esc($kehadiran['izin'] ?? 0) ?> hari</td>
                            </tr>
                            <tr>
                                <td>Tanpa Keterangan</td>
                                <td>: <?= esc($kehadiran['alpha'] ?? 0) ?> hari</td>
                            </tr>
                        </tbody>
                    </table>
                </td>

                <td style="width: 50%;">
                    <p class="section-title">D. Catatan Guru Kelas</p>
                    <table class="catatan-wali-kelas">
                        <tbody>
                            <tr>
                                <td style="height: 50px; vertical-align: top;">
                                    <strong>Catatan:</strong><br>
                                    <?= esc($catatan['catatan_umum'] ?? '-') ?>
                                </td>
                            </tr>
                            <tr>
                                <td style="vertical-align: top;">
                                    <strong>Saran:</strong><br>
                                    <?= esc($catatan['saran_saran'] ?? '-') ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </table>

        <table class="ttd-table">
            <tr>
                <td style="width: 45%;">
                    <p>Mengetahui,</p>
                    <p>Orang Tua/Wali</p>
                    <br><br>
                    <p class="nama-gelar">( ........................... )</p>
                </td>
                <td style="width: 10%;"></td>
                <td style="width: 45%;">
                    <p><?= esc($sekolah['tempat_rapor'] ?? '') ?>, <?= date('d-m-Y', strtotime($sekolah['tanggal_rapor'] ?? '')) ?></p>
                    <p>Guru Kelas,</p>
                    <br><br>
                    <p class="nama-gelar"><?= esc($waliKelas['nama']) ?></p>
                    <p class="nip">NIP. <?= esc($waliKelas['nip'] ?? '-') ?></p>
                </td>
            </tr>
            <tr>
                <td colspan="3" style="text-align: center; padding-top: 50px;">
                    <p>Kepala Sekolah,</p>
                    <br><br>
                    <p class="nama-gelar"><?= esc($kepalaSekolah['nama']) ?></p>
                    <p class="nip">NIP. <?= esc($kepalaSekolah['nip'] ?? '-') ?></p>
                </td>
            </tr>
        </table>

    </div>
</body>
</html>
