<?= $this->extend('layout/guru_layout') ?>

<?= $this->section('title') ?>Edit Tujuan Pembelajaran<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="container">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Edit Tujuan Pembelajaran</h3>
        </div>
        <div class="card-body">
            <?php if (session()->getFlashdata('errors')) : ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php foreach (session()->getFlashdata('errors') as $error) : ?>
                            <li><?= esc($error) ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>
            <?php if (session()->getFlashdata('error')) : ?>
                <div class="alert alert-danger">
                    <?= session()->getFlashdata('error') ?>
                </div>
            <?php endif; ?>

            <?php if (empty($kelas_options)) : ?>
                <div class="alert alert-warning">Anda belum terdaftar mengajar di kelas manapun. Tidak dapat mengedit TP.</div>
            <?php else : ?>
                <form action="<?= base_url('guru/tp_mapel/update/' . $tp['id']) ?>" method="post">
                    <?= csrf_field() ?>
                    <input type="hidden" name="_method" value="PUT"> 

                    <div class="mb-3">
                        <label for="kelas_id" class="form-label">Kelas:</label>
                        <select class="form-control" id="kelas_id" name="kelas_id" required>
                            <option value="">Pilih Kelas</option>
                            <?php foreach ($kelas_options as $kls) : ?>
                                <option value="<?= esc($kls['id_kelas']) ?>" <?= (old('kelas_id', $tp['kelas_id']) == $kls['id_kelas']) ? 'selected' : '' ?>>
                                    <?= esc($kls['nama_kelas']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="mapel_id" class="form-label">Mata Pelajaran:</label>
                        <select class="form-control" id="mapel_id" name="mapel_id" required>
                            <option value="">Pilih Mata Pelajaran</option>
                            <?php foreach ($mata_pelajaran as $mapel) : ?>
                                <option value="<?= esc($mapel['id']) ?>" <?= (old('mapel_id', $tp['mapel_id']) == $mapel['id']) ? 'selected' : '' ?>>
                                    <?= esc($mapel['nama_mapel']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <!-- Tambah input untuk semester -->
                    <div class="mb-3">
                        <label for="semester" class="form-label">Semester:</label>
                        <select class="form-control" id="semester" name="semester" required>
                            <option value="">Pilih Semester</option>
                            <?php foreach ($semester_options as $sem) : ?>
                                <option value="<?= esc($sem) ?>" <?= (old('semester', $tp['semester']) == $sem) ? 'selected' : '' ?>>
                                    <?= esc($sem) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="kode_tp" class="form-label">Kode TP:</label>
                        <input type="text" class="form-control" id="kode_tp" name="kode_tp" value="<?= old('kode_tp', $tp['kode_tp']) ?>" required readonly>
                    </div>

                    <div class="mb-3">
                        <label for="deskripsi_tp" class="form-label">Deskripsi TP:</label>
                        <textarea class="form-control" id="deskripsi_tp" name="deskripsi_tp" rows="5" required><?= old('deskripsi_tp', $tp['deskripsi_tp']) ?></textarea>
                    </div>

                    <button type="submit" class="btn btn-success">Perbarui TP</button>
                    <a href="<?= base_url('guru/tp_mapel') ?>" class="btn btn-secondary">Batal</a>
                </form>
            <?php endif; ?>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
