<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\SekolahModel;
use App\Models\UserModel;

class Sekolah extends BaseController
{
    protected $sekolahModel;
    protected $userModel;

    public function __construct()
    {
        $this->sekolahModel = new SekolahModel();
        $this->userModel = new UserModel();
    }

    public function index()
    {
        $daftarSekolah = $this->sekolahModel->findAll();
        $isSekolahExists = !empty($daftarSekolah);

        // Ambil nama kepala sekolah jika ada
        foreach ($daftarSekolah as &$sekolah) {
            if (!empty($sekolah['kepala_sekolah_id'])) {
                $kepalaSekolah = $this->userModel->find($sekolah['kepala_sekolah_id']);
                $sekolah['nama_kepala_sekolah'] = $kepalaSekolah ? $kepalaSekolah['nama'] : 'Tidak Ditemukan';
            } else {
                $sekolah['nama_kepala_sekolah'] = '-';
            }
        }
        unset($sekolah);

        $data = [
            'title'             => 'Manajemen Sekolah',
            'daftarSekolah'     => $daftarSekolah,
            'isSekolahExists'   => $isSekolahExists
        ];

        return view('admin/sekolah/index', $data);
    }

    public function new()
    {
        // Cek apakah sudah ada data sekolah
        if ($this->sekolahModel->countAllResults() > 0) {
            session()->setFlashdata('error', 'Hanya satu data sekolah yang dapat dibuat.');
            return redirect()->to(base_url('admin/sekolah'));
        }

        $kepalaSekolahOptions = $this->userModel->findAll();
        $data = [
            'title'        => 'Tambah Data Sekolah',
            'kepalaSekolahOptions' => $kepalaSekolahOptions,
        ];
        return view('admin/sekolah/create', $data);
    }

    public function save()
    {
        // Cek apakah sudah ada data sekolah sebelum menyimpan
        if ($this->sekolahModel->countAllResults() > 0) {
            session()->setFlashdata('error', 'Gagal: Hanya satu data sekolah yang dapat dibuat.');
            return redirect()->to(base_url('admin/sekolah'));
        }

        $data = [
            'nama_sekolah'      => $this->request->getVar('nama_sekolah'),
            'nss'               => $this->request->getVar('nss'),
            'npsn'              => $this->request->getVar('npsn'),
            'alamat'            => $this->request->getVar('alamat'),
            'kode_pos'          => $this->request->getVar('kode_pos'),
            'telp'              => $this->request->getVar('telp'),
            'kelurahan_desa'    => $this->request->getVar('kelurahan_desa'),
            'kapanewon'         => $this->request->getVar('kapanewon'),
            'kabupaten_kota'    => $this->request->getVar('kabupaten_kota'),
            'provinsi'          => $this->request->getVar('provinsi'),
            'website'           => $this->request->getVar('website'),
            'email'             => $this->request->getVar('email'),
            'tempat_rapor'      => $this->request->getVar('tempat_rapor'),
            'tanggal_rapor'     => $this->request->getVar('tanggal_rapor'),
            'kepala_sekolah_id' => $this->request->getVar('kepala_sekolah_id') ?: null,
        ];

        $this->sekolahModel->save($data);
        session()->setFlashdata('success', 'Data sekolah berhasil ditambahkan.');

        return redirect()->to(base_url('admin/sekolah'));
    }

    public function edit($id)
    {
        $sekolah = $this->sekolahModel->find($id);
        if (empty($sekolah)) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Data sekolah tidak ditemukan: ' . $id);
        }

        $kepalaSekolahOptions = $this->userModel->findAll();
        $data = [
            'title'                => 'Edit Data Sekolah',
            'sekolah'              => $sekolah,
            'kepalaSekolahOptions' => $kepalaSekolahOptions,
        ];

        return view('admin/sekolah/edit', $data);
    }

    public function update($id)
    {
        if (!$this->request->is('post')) {
            return redirect()->to(base_url('admin/sekolah'));
        }

        $dataToUpdate = [
            'nama_sekolah'      => $this->request->getVar('nama_sekolah'),
            'nss'               => $this->request->getVar('nss'),
            'npsn'              => $this->request->getVar('npsn'),
            'alamat'            => $this->request->getVar('alamat'),
            'kode_pos'          => $this->request->getVar('kode_pos'),
            'telp'              => $this->request->getVar('telp'),
            'kelurahan_desa'    => $this->request->getVar('kelurahan_desa'),
            'kapanewon'         => $this->request->getVar('kapanewon'),
            'kabupaten_kota'    => $this->request->getVar('kabupaten_kota'),
            'provinsi'          => $this->request->getVar('provinsi'),
            'website'           => $this->request->getVar('website'),
            'email'             => $this->request->getVar('email'),
            'tempat_rapor'      => $this->request->getVar('tempat_rapor'),
            'tanggal_rapor'     => $this->request->getVar('tanggal_rapor'),
            'kepala_sekolah_id' => $this->request->getVar('kepala_sekolah_id') ?: null,
        ];
        
        $updateResult = $this->sekolahModel->update($id, $dataToUpdate);

        if ($updateResult) {
            session()->setFlashdata('success', 'Data sekolah berhasil diperbarui.');
        } else {
            session()->setFlashdata('error', 'Tidak ada perubahan data atau gagal memperbarui data.');
        }
        
        return redirect()->to(base_url('admin/sekolah'));
    }

    public function delete($id)
    {
        if ($this->sekolahModel->delete($id)) {
            session()->setFlashdata('success', 'Data sekolah berhasil dihapus.');
        } else {
            session()->setFlashdata('error', 'Gagal menghapus data sekolah.');
        }
        return redirect()->to(base_url('admin/sekolah'));
    }
}
